/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel;

import br.ufrj.labma.enibam.kernel.Areable;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.GraphManager;
import br.ufrj.labma.enibam.kernel.InstanceManager;
import br.ufrj.labma.enibam.kernel.InversePropagationElement;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelEnvironment;
import br.ufrj.labma.enibam.kernel.KernelFactory;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPolygon;
import br.ufrj.labma.enibam.kernel.KernelProxy;
import br.ufrj.labma.enibam.kernel.KernelUnitaryMeasure;
import br.ufrj.labma.enibam.kernel.Lengthable;
import br.ufrj.labma.enibam.kernel.Measure;
import br.ufrj.labma.enibam.kernel.Movable;
import br.ufrj.labma.enibam.kernel.ProgramManager;
import br.ufrj.labma.enibam.kernel.StateInstancePool;
import br.ufrj.labma.enibam.kernel.Translatable;
import br.ufrj.labma.enibam.kernel.exception.ElementNotFoundException;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.LocusState;
import br.ufrj.labma.enibam.kernel.state.PolygonState;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class TabulaeKernel
implements KernelProxy {
    private KernelEnvironment KEnv;
    private GraphManager GM;
    private ProgramManager PM;
    private InstanceManager IM;
    private KernelFactory KF;
    private StateInstancePool itsStatePool;
    private String DebugMode = "0";

    public TabulaeKernel() {
        this.initDefault();
    }

    @Override
    public int[] create(int constructionID, List ParamList) {
        ArrayList<Integer> _l = ParamList != null ? new ArrayList<Integer>(ParamList) : null;
        FactoryCreationParameter _FCP = new FactoryCreationParameter(new Integer(constructionID), _l);
        return this.create(_FCP);
    }

    @Override
    public int[] create(FactoryCreationParameter FCP) {
        long _t0 = 0L;
        if (!this.DebugMode.equals("0")) {
            _t0 = System.currentTimeMillis();
        }
        FCP.setParentsList(FCP.getParentsList());
        int[] mid = this.KF.create(FCP);
        if (!this.DebugMode.equals("0")) {
            long _t1 = System.currentTimeMillis();
            String str = "KernelProxy: Construindo MID(s): ";
            int _i = 0;
            while (_i < mid.length) {
                str = String.valueOf(str) + mid[_i] + " ";
                ++_i;
            }
            str = String.valueOf(str) + "\nArgumentos da constru\u00e7\u00e3o: " + FCP + "\n";
            str = String.valueOf(str) + "Tempo gasto no kernel para realizar a constru\u00e7\u00e3o: =>" + (_t1 - _t0) + " millisecond(s)\n";
            System.out.println(str);
        }
        return mid;
    }

    @Override
    public int[] getSiblings(int mathID) {
        return this.KF.getSiblings(this.getFCP(mathID));
    }

    @Override
    public Set destroy(int mathID) {
        Integer MID = new Integer(mathID);
        this.KF.checkExistence(MID);
        return this.KF.destroy(MID);
    }

    @Override
    public FactoryCreationParameter getFCP(Integer MID) {
        this.KF.checkExistence(MID);
        return this.KF.getFCP(MID);
    }

    @Override
    public int getConstructionID(int MathID) {
        Integer MID = new Integer(MathID);
        this.KF.checkExistence(MID);
        return this.GM.getConstructionID(MID);
    }

    @Override
    public void move(int mathID, CoorSys coord, Set s) {
        Integer MID = new Integer(mathID);
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        ((Movable)((Object)ke)).move(coord.itsX, coord.itsY);
        ke.update();
        s.clear();
        Set _tmp = this.GM.getAllEssentialUpdateReceivers(MID);
        s.addAll(_tmp);
        s.add(MID);
        this.KF.filterZombis(s);
    }

    @Override
    public void translate(int mathID, CoorSys coord, Set s) {
        Integer MID = new Integer(mathID);
        this.KF.checkExistence(MID);
        long _t0 = 0L;
        if (!this.DebugMode.equals("0")) {
            _t0 = System.currentTimeMillis();
        }
        KernelElement ke = this.IM.getInstance(MID);
        ((Translatable)((Object)ke)).translate(coord.itsX, coord.itsY);
        ke.update();
        s.clear();
        Set _tmp = this.GM.getAllEssentialUpdateReceivers(MID);
        s.addAll(_tmp);
        s.add(MID);
        this.KF.filterZombis(s);
        if (!this.DebugMode.equals("0")) {
            long _t1 = System.currentTimeMillis();
            String str = "KernelProxy: Transladando MID " + mathID + " em  " + coord;
            str = String.valueOf(str) + "Tempo gasto no kernel para fazer translate + update: ==>" + (_t1 - _t0) + "millisecond(s)\n";
            System.out.println(str);
        }
    }

    @Override
    public void translateSet(Set mathIDs, CoorSys coord, Set s) {
        HashSet<KernelElement> invPropSet = new HashSet<KernelElement>();
        HashSet<KernelElement> translateSet = new HashSet<KernelElement>();
        for (Integer MID : mathIDs) {
            KernelElement ke = this.IM.getInstance(MID);
            this.KF.checkExistence(MID);
            if (ke instanceof InversePropagationElement) {
                invPropSet.add(ke);
                KernelElement[] fw = ((InversePropagationElement)ke).getFWSet();
                if (fw == null) continue;
                int j = 0;
                while (j < fw.length) {
                    translateSet.add(fw[j]);
                    ++j;
                }
                continue;
            }
            translateSet.add(ke);
        }
        translateSet.removeAll(invPropSet);
        s.clear();
        for (KernelElement ke : translateSet) {
            Integer MID = ke.getMID();
            ((Translatable)((Object)ke)).translate(coord.itsX, coord.itsY);
            ke.update();
            Set _tmp = this.GM.getAllEssentialUpdateReceivers(MID);
            s.addAll(_tmp);
            s.add(MID);
        }
        this.KF.filterZombis(s);
    }

    @Override
    public State getState(int mathID) {
        Integer MID = new Integer(mathID);
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        State _state = this.itsStatePool.getStateOfType(ke.getClass());
        ke.getState(_state);
        if (!this.DebugMode.equals("0")) {
            String str = "KernelProxy: Fazendo getState() no MID " + MID;
            System.out.println(str);
        }
        _state.itsMID = new Integer(mathID);
        return _state;
    }

    @Override
    public List getImediateParents(Integer MID) {
        this.KF.checkExistence(MID);
        TreeSet s = new TreeSet(this.GM.getImediateParents(MID));
        ArrayList l = new ArrayList(s);
        return l;
    }

    @Override
    public SortedSet getAllChildrenLevelOrdered(Integer MID) {
        this.KF.checkExistence(MID);
        return this.GM.getAllChildrenLevelOrdered(MID);
    }

    @Override
    public boolean isMoveable(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ke instanceof Movable;
    }

    @Override
    public boolean isTranslatable(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ke instanceof Translatable;
    }

    @Override
    public boolean isAreable(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ke instanceof Areable;
    }

    @Override
    public double getArea(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ((Areable)ke).getArea();
    }

    @Override
    public boolean isLengthable(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ke instanceof Lengthable;
    }

    @Override
    public double getLength(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ((Lengthable)ke).getLength();
    }

    @Override
    public boolean isMeasure(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ke instanceof Measure;
    }

    @Override
    public double getMeasure(Integer MID) {
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        return ((Measure)ke).getMeasure();
    }

    @Override
    public boolean exists(Integer MID) {
        try {
            this.KF.checkExistence(MID);
            return true;
        }
        catch (ElementNotFoundException e) {
            return false;
        }
    }

    @Override
    public void setUnitaryMeasure(double k) {
        KernelUnitaryMeasure um = this.KEnv.getUnitaryMeasure();
        um.setUnitaryMeasure(k);
        um.update();
    }

    @Override
    public double getUnitaryMeasure() {
        KernelUnitaryMeasure um = this.KEnv.getUnitaryMeasure();
        return um.getUnitaryMeasure();
    }

    @Override
    public Integer getUnitaryMeasureID() {
        return this.KEnv.getUnitaryMeasure().getMID();
    }

    @Override
    public State changeState(int mathID, State st) {
        Integer MID = new Integer(mathID);
        this.KF.checkExistence(MID);
        KernelElement ke = this.IM.getInstance(MID);
        if (st instanceof LocusState) {
            ((KernelLocus)ke).changeState(st);
        }
        if (st instanceof PolygonState) {
            ((KernelPolygon)ke).changeState(st);
        }
        ke.changeState(st);
        return st;
    }

    private void initDefault() {
        this.KEnv = new KernelEnvironment();
        this.GM = this.KEnv.getGraphManager();
        this.PM = this.KEnv.getProgramManager();
        this.IM = this.KEnv.getInstanceManager();
        this.KF = this.KEnv.getKernelFactory();
        this.itsStatePool = new StateInstancePool();
    }

    public String toString() {
        return "" + this.IM + this.PM + this.GM + this.KF;
    }

    public GraphManager getGraphManager() {
        return this.GM;
    }

    public InstanceManager getInstanceManager() {
        return this.IM;
    }

    public ProgramManager getProgamManager() {
        return this.PM;
    }

    public KernelFactory getKernelFactory() {
        return this.KF;
    }
}

