/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.builder;

import br.ufrj.labma.enibam.kernel.AbstractKernelLocus;
import br.ufrj.labma.enibam.kernel.FactoryCreationParameter;
import br.ufrj.labma.enibam.kernel.KernelAdapLocus;
import br.ufrj.labma.enibam.kernel.KernelCircleLocus;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelLineLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelPolyLocus;
import br.ufrj.labma.enibam.kernel.KernelSplineLocus;
import br.ufrj.labma.enibam.kernel.Program;
import br.ufrj.labma.enibam.kernel.builder.AbstractBuilder;
import br.ufrj.labma.enibam.kernel.constraint.RebuildLocusConstraint;
import br.ufrj.labma.enibam.kernel.exception.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LocusBuilder
extends AbstractBuilder {
    private Class itsElementClass;
    private Class itsConstraintClass;
    private int itsOutputNumber;

    public LocusBuilder(Class ConstructionClass, Integer ConstructionID, Class ElementClass, Class constraintClass, int OutputNumber) {
        super(ConstructionClass, ConstructionID);
        this.itsElementClass = ElementClass;
        this.itsConstraintClass = constraintClass;
        this.itsOutputNumber = OutputNumber;
    }

    @Override
    public int[] create(FactoryCreationParameter FCP) throws BuilderException {
        AbstractKernelLocus instance;
        List<Integer> ParentsList = FCP.getParentsList();
        Integer CID = FCP.getConstructionID();
        if (!CID.equals(this.itsConstructionID)) {
            throw new BuilderException("Este Builder : " + this.getClass().getName() + " n\u00e3o est\u00e1 habilitado a realizar construc\u00f5es de ConstID = " + CID + "\n");
        }
        int mid = this.KF.alocaMID();
        Integer MID = new Integer(mid);
        Program prog = null;
        Iterator<Integer> _i = ParentsList.iterator();
        KernelElement a = this.IM.getInstance(_i.next());
        KernelPoint b = (KernelPoint)this.IM.getInstance(_i.next());
        int type = FCP.getParamI0();
        int npoints = FCP.getParamI1();
        if (npoints == -1) {
            npoints = type == 8020 ? 100 : (type == 8010 ? 30 : (type == 8030 ? 50 : (type == 8070 ? 150 : (type == 8060 ? 50 : (type == 8050 ? 50 : (type == 8040 ? 50 : 30))))));
        }
        Integer directorID = this.IM.getMID(b);
        Integer pathID = this.GM.getTheParent(directorID);
        KernelElement path = this.IM.getInstance(pathID);
        if (type == 8020) {
            instance = new KernelPolyLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8070) {
            instance = new KernelAdapLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8010) {
            instance = new KernelSplineLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8030) {
            instance = new KernelLineLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8050) {
            instance = new KernelLineLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8060) {
            instance = new KernelLineLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else if (type == 8040) {
            instance = new KernelCircleLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        } else {
            instance = new KernelPolyLocus(MID, prog);
            instance.initDefault(a, b, npoints, path);
        }
        HashSet<Integer> list = new HashSet<Integer>(5);
        list.add(this.IM.getMID(a));
        this.GM.add(MID, list, this.itsConstructionID);
        this.IM.add(MID, instance);
        RebuildLocusConstraint algo = new RebuildLocusConstraint(a, b, instance);
        instance.setConstraint(algo);
        this.GM.dontUpdate(directorID, MID);
        this.PM.addConstraint(algo, this.GM.getAllEssentialUpdateOriginators(MID));
        return new int[]{mid};
    }
}

