/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Projection;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;

public abstract class AbstractPointInGenericLineConstraint
extends AbstractConstraint {
    private CoorSys _p = new CoorSys();
    protected CoorSys _p1 = new CoorSys();
    protected CoorSys _p2 = new CoorSys();
    protected double itsK;
    private KernelPoint _thePoint;
    private KernelGenericLine _theGline;
    private static double TOLERANCE = 1.0E-6;

    public AbstractPointInGenericLineConstraint(KernelGenericLine r, KernelPoint p) {
        super(2, 1);
        this._thePoint = p;
        this.theOutput[0] = this._thePoint;
        this.theInput[0] = this._thePoint;
        this._theGline = r;
        this.theInput[1] = this._theGline;
        this._thePoint.getXY(this._p);
        this.itsK = this.getCurrentK(this._p);
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this._theGline.getDefinedStatus()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theOutput[0].setDefinedStatus(true);
        CoorSys _X = this.getCurrentPosition(this.itsK);
        if (!this._theGline.contains(_X)) {
            this.correct(_X);
        }
        this._thePoint.setXY(_X);
    }

    @Override
    public boolean isOk(State st1) {
        PointState st = (PointState)st1;
        this._p.itsX = st.itsX;
        this._p.itsY = st.itsY;
        this._p.itsDefinedStatus = st.itsDefinedStatus;
        if (!this._theGline.getDefinedStatus()) {
            this._thePoint.setDefinedStatus(false);
            return false;
        }
        this._thePoint.setDefinedStatus(true);
        Projection.getProjection(this._p, this._theGline);
        if (!this._theGline.contains(this._p)) {
            this.correct(this._p);
        }
        this.itsK = this.getCurrentK(this._p);
        st.itsX = this._p.itsX;
        st.itsY = this._p.itsY;
        st.itsDefinedStatus = this._p.itsDefinedStatus;
        return true;
    }

    protected abstract void correct(CoorSys var1);

    protected double getCurrentK(CoorSys P) {
        this._theGline.getP1P2(this._p1, this._p2);
        double _xP = P.itsX;
        double _yP = P.itsY;
        double _x1 = this._p1.itsX;
        double _y1 = this._p1.itsY;
        double _x2 = this._p2.itsX;
        double _y2 = this._p2.itsY;
        double _qx = _x2 - _x1;
        double _qy = _y2 - _y1;
        if (Math.abs(_qx) <= TOLERANCE && Math.abs(_qy) <= TOLERANCE) {
            return 0.5;
        }
        if (Math.abs(_qy) <= TOLERANCE) {
            return (_xP - _x1) / _qx;
        }
        return (_yP - _y1) / _qy;
    }

    protected CoorSys getCurrentPosition(double k) {
        this._theGline.getP1P2(this._p1, this._p2);
        this._p1.itsX = this._p1.itsX * (1.0 - k) + k * this._p2.itsX;
        this._p1.itsY = this._p1.itsY * (1.0 - k) + k * this._p2.itsY;
        return this._p1;
    }
}

