/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelAngle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class AngleGlueConstraint
extends AbstractConstraint {
    private CoorSys Vba = new CoorSys();
    private CoorSys Vbc = new CoorSys();
    private KernelPoint _theP0;
    private KernelPoint _theP1;
    private KernelPoint _theP2;
    private KernelAngle _theAngle;

    public AngleGlueConstraint(KernelPoint A, KernelPoint B, KernelPoint C, KernelAngle angle) {
        super(3, 1);
        this._theP0 = A;
        this.theInput[0] = this._theP0;
        this._theP1 = B;
        this.theInput[1] = this._theP1;
        this._theP2 = C;
        this.theInput[2] = this._theP2;
        this._theAngle = angle;
        this.theOutput[0] = this._theAngle;
        this.calculate();
    }

    @Override
    public void calculate() {
        double ab_sin;
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theOutput[0].setDefinedStatus(true);
        this.Vba.itsX = this._theP0.getX() - this._theP1.getX();
        this.Vba.itsY = this._theP0.getY() - this._theP1.getY();
        this.Vbc.itsX = this._theP2.getX() - this._theP1.getX();
        this.Vbc.itsY = this._theP2.getY() - this._theP1.getY();
        double cos = (this.Vba.itsX * this.Vbc.itsX + this.Vba.itsY * this.Vbc.itsY) / (Math.sqrt(this.Vba.itsX * this.Vba.itsX + this.Vba.itsY * this.Vba.itsY) * Math.sqrt(this.Vbc.itsX * this.Vbc.itsX + this.Vbc.itsY * this.Vbc.itsY));
        if (cos > 1.0) {
            cos = 1.0;
        }
        if (cos < -1.0) {
            cos = -1.0;
        }
        double _angle = (ab_sin = this.Vba.itsX * this.Vbc.itsY - this.Vba.itsY * this.Vbc.itsX) >= 0.0 ? Math.acos(cos) : -Math.acos(cos);
        this._theAngle.setAngle(_angle);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

