/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CentralSymmetry;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class ArcCentralSymmetryConstraint
extends AbstractConstraint {
    private KernelPoint theMirror;
    private KernelArc theSubject;
    private KernelArc theImage;
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();
    private CoorSys _p3 = new CoorSys();
    private CoorSys _mirror = new CoorSys();

    public ArcCentralSymmetryConstraint(KernelArc subject, KernelPoint mirror, KernelArc image) {
        super(2, 1);
        this.theSubject = subject;
        this.theInput[0] = this.theSubject;
        this.theMirror = mirror;
        this.theInput[1] = this.theMirror;
        this.theImage = image;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.get3Points(this._p1, this._p2, this._p3);
        this.theMirror.getXY(this._mirror);
        CentralSymmetry.getPointCentralSymmetry(this._p1, this._mirror);
        CentralSymmetry.getPointCentralSymmetry(this._p2, this._mirror);
        CentralSymmetry.getPointCentralSymmetry(this._p3, this._mirror);
        this.theImage.set3Points(this._p1, this._p2, this._p3);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

