/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Dilation;
import br.ufrj.labma.enibam.kernel.state.State;

public class ArcDilationConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelArc theSubject;
    private KernelArc theDilated;
    private KernelRatio theRatio;
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();
    private CoorSys _p3 = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public ArcDilationConstraint(KernelPoint center, KernelArc subject, KernelRatio ratio, KernelArc dilated) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theDilated = dilated;
        this.theOutput[0] = this.theDilated;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.get3Points(this._p1, this._p2, this._p3);
        this.theCenter.getXY(this._Center);
        Dilation.getPointDilation(this._Center, this.theRatio, this._p1);
        Dilation.getPointDilation(this._Center, this.theRatio, this._p2);
        Dilation.getPointDilation(this._Center, this.theRatio, this._p3);
        this.theDilated.set3Points(this._p1, this._p2, this._p3);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

