/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Inversion;
import br.ufrj.labma.enibam.kernel.state.State;

public class ArcInversionConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelArc theSubject;
    private KernelArc theImage;
    private KernelRatio theRatio;
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();
    private CoorSys _p3 = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public ArcInversionConstraint(KernelPoint center, KernelArc subject, KernelRatio ratio, KernelArc image) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theImage = image;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.get3Points(this._p1, this._p2, this._p3);
        this.theCenter.getXY(this._Center);
        Inversion.getPointInversion(this._Center, this.theRatio, this._p1);
        Inversion.getPointInversion(this._Center, this.theRatio, this._p2);
        Inversion.getPointInversion(this._Center, this.theRatio, this._p3);
        this.theImage.set3Points(this._p1, this._p2, this._p3);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

