/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRay;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class BissectorConstraint
extends AbstractConstraint {
    private KernelPoint theP1;
    private KernelPoint theP2;
    private KernelPoint theP3;
    private KernelRay theO1;
    private MathVector _v1 = new MathVector();
    private MathVector _v2 = new MathVector();
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();

    public BissectorConstraint(KernelPoint p1, KernelPoint p2, KernelPoint p3, KernelRay o1) {
        super(3, 1);
        this.theP1 = p1;
        this.theInput[0] = this.theP1;
        this.theP2 = p2;
        this.theInput[1] = this.theP2;
        this.theP3 = p3;
        this.theInput[2] = this.theP3;
        this.theO1 = o1;
        this.theOutput[0] = this.theO1;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theO1.setDefinedStatus(false);
            return;
        }
        this.theO1.setDefinedStatus(true);
        this.theP2.getXY(this._p1);
        this.calculateP2(this._p2);
        this.theO1.setP1P2(this._p1, this._p2);
    }

    private void calculateP2(CoorSys _cs) {
        double x1 = this.theP1.getX();
        double y1 = this.theP1.getY();
        double x2 = this.theP2.getX();
        double y2 = this.theP2.getY();
        double x3 = this.theP3.getX();
        double y3 = this.theP3.getY();
        this._v1.setVector(x2, y2, x1, y1);
        this._v2.setVector(x2, y2, x3, y3);
        this._v1.unitario();
        this._v2.unitario();
        this._v1.productByNumber(100.0);
        this._v2.productByNumber(100.0);
        this._v1.sum(this._v2);
        _cs.itsX = this.theP2.getX() + this._v1.getX();
        _cs.itsY = this.theP2.getY() + this._v1.getY();
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

