/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CentralSymmetry;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class CircleCentralSymmetryConstraint
extends AbstractConstraint {
    private KernelPoint theMirror;
    private KernelCircle theSubject;
    private KernelCircle theImage;
    private CoorSys _p = new CoorSys();
    private CoorSys _mirror = new CoorSys();

    public CircleCentralSymmetryConstraint(KernelCircle subject, KernelPoint mirror, KernelCircle image) {
        super(2, 1);
        this.theSubject = subject;
        this.theInput[0] = this.theSubject;
        this.theMirror = mirror;
        this.theInput[1] = this.theMirror;
        this.theImage = image;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getCenter(this._p);
        this.theMirror.getXY(this._mirror);
        CentralSymmetry.getPointCentralSymmetry(this._p, this._mirror);
        this.theImage.setCenterRadius(this._p, this.theSubject.getRadius());
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

