/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Dilation;
import br.ufrj.labma.enibam.kernel.state.State;

public class CircleDilationConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelCircle theSubject;
    private KernelCircle theDilated;
    private KernelRatio theRatio;
    private CoorSys P = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public CircleDilationConstraint(KernelPoint center, KernelCircle subject, KernelRatio ratio, KernelCircle dilated) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theDilated = dilated;
        this.theOutput[0] = this.theDilated;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getCenter(this.P);
        this.theCenter.getXY(this._Center);
        Dilation.getPointDilation(this._Center, this.theRatio, this.P);
        this.theDilated.setCenterRadius(this.P, this.theRatio.getRatio() * this.theSubject.getRadius());
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

