/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelConic;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Dilation;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;

public class ConicDilationConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelConic theConic;
    private KernelConic theO;
    private KernelRatio theRatio;
    private ArrayList y;
    private CoorSys P = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public ConicDilationConstraint(KernelPoint center, KernelConic c, KernelRatio ratio, KernelConic o) {
        super(3, 1);
        this.theConic = c;
        this.theInput[0] = this.theConic;
        this.theCenter = center;
        this.theInput[1] = this.theCenter;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theO = o;
        this.theOutput[0] = this.theO;
        this.y = new ArrayList(c.getNumberOfPoints());
        ArrayList k = (ArrayList)this.theConic.getPointVector();
        int i = 0;
        while (i < k.size()) {
            CoorSys P1 = (CoorSys)k.get(i);
            this.y.add(new CoorSys(P1.itsX, P1.itsY));
            ++i;
        }
        this.theO.setPointVector(this.y);
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theCenter.getXY(this._Center);
        ArrayList k = (ArrayList)this.theConic.getPointVector();
        this.y = (ArrayList)this.theO.getPointVector();
        int i = 0;
        while (i < this.y.size()) {
            this.P.itsX = ((CoorSys)k.get((int)i)).itsX;
            this.P.itsY = ((CoorSys)k.get((int)i)).itsY;
            Dilation.getPointDilation(this._Center, this.theRatio, this.P);
            CoorSys m = (CoorSys)this.y.get(i);
            m.itsX = this.P.itsX;
            m.itsY = this.P.itsY;
            ++i;
        }
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

