/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelConic;
import br.ufrj.labma.enibam.kernel.KernelVector;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Translation;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;

public class ConicTranslationConstraint
extends AbstractConstraint {
    private KernelConic theConic;
    private KernelConic theO;
    private KernelVector theVector;
    private ArrayList y;
    private CoorSys P = new CoorSys();

    public ConicTranslationConstraint(KernelConic c, KernelVector vec, KernelConic o) {
        super(2, 1);
        this.theConic = c;
        this.theInput[0] = this.theConic;
        this.theVector = vec;
        this.theInput[1] = this.theVector;
        this.theO = o;
        this.theOutput[0] = this.theO;
        this.y = new ArrayList(this.theConic.getNumberOfPoints());
        ArrayList k = (ArrayList)this.theConic.getPointVector();
        int i = 0;
        while (i < k.size()) {
            CoorSys P1 = (CoorSys)k.get(i);
            this.y.add(new CoorSys(P1.itsX, P1.itsY));
            ++i;
        }
        this.theO.setPointVector(this.y);
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        ArrayList k = (ArrayList)this.theConic.getPointVector();
        this.y = (ArrayList)this.theO.getPointVector();
        int i = 0;
        while (i < this.y.size()) {
            this.P.itsX = ((CoorSys)k.get((int)i)).itsX;
            this.P.itsY = ((CoorSys)k.get((int)i)).itsY;
            Translation.getPointTranslated(this.theVector, this.P);
            CoorSys m = (CoorSys)this.y.get(i);
            m.itsX = this.P.itsX;
            m.itsY = this.P.itsY;
            ++i;
        }
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

