/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelAxes;
import br.ufrj.labma.enibam.kernel.KernelCoordinate;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class CoordinateGlueConstraint
extends AbstractConstraint {
    private KernelPoint _theI0;
    private KernelAxes _theI1;
    private KernelCoordinate _theCoor;
    private CoorSys _origin = new CoorSys();
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();

    public CoordinateGlueConstraint(KernelPoint P, KernelAxes axes, KernelCoordinate coor) {
        super(2, 1);
        this._theI0 = P;
        this.theInput[0] = this._theI0;
        this._theI1 = axes;
        this.theInput[1] = this._theI1;
        this._theCoor = coor;
        this.theOutput[0] = this._theCoor;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theOutput[0].setDefinedStatus(true);
        this._theI1.getOrigin(this._origin);
        this._theI1.getP1(this._p1);
        this._theI1.getP2(this._p2);
        double x0 = this._origin.itsX;
        double y0 = this._origin.itsY;
        double x1 = this._p1.itsX;
        double y1 = this._p1.itsY;
        double x2 = this._p2.itsX;
        double y2 = this._p2.itsY;
        double x = this._theI0.getX();
        double y = this._theI0.getY();
        double denominador = x1 * y2 - x1 * y0 - x0 * y2 - x2 * y1 + x2 * y0 + x0 * y1;
        double newx = -1.0 * (-y2 + y0) * (x - x0) + (-x2 + x0) * (y - y0) / denominador;
        double newy = (-y1 + y0) * (x - x0) - (-x1 + x0) * (y - y0) / denominador;
        this._theCoor.setCoordinate(newx, newy);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

