/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class GenericLineCircleIntersectionConstraint
extends AbstractConstraint {
    private CoorSys p1 = new CoorSys();
    private CoorSys p2 = new CoorSys();
    private KernelGenericLine _theI0;
    private KernelCircle _theI1;
    private KernelPoint _theO0;
    private KernelPoint _theO1;
    private static final double TOLERANCE = 1.0E-4;

    public GenericLineCircleIntersectionConstraint(KernelGenericLine i1, KernelCircle i2, KernelPoint o1, KernelPoint o2) {
        super(2, 2);
        this._theI0 = i1;
        this.theInput[0] = this._theI0;
        this._theI1 = i2;
        this.theInput[1] = this._theI1;
        this._theO0 = o1;
        this.theOutput[0] = this._theO0;
        this._theO1 = o2;
        this.theOutput[1] = this._theO1;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            this.theOutput[1].setDefinedStatus(false);
            return;
        }
        double a = this._theI0.getA();
        double b = this._theI0.getB();
        double c = this._theI0.getC();
        double x0 = this._theI1.getCenterX();
        double y0 = this._theI1.getCenterY();
        double r = this._theI1.getRadius();
        double tmp = a * a + b * b;
        double d = Math.abs(a * x0 + b * y0 + c) / Math.sqrt(tmp);
        double delta = d - r;
        if (delta <= 1.0E-4) {
            if (delta >= 0.0) {
                d = r;
            }
            double px = (b * b * x0 - b * a * y0 - c * a) / tmp;
            double py = (-a * b * x0 + a * a * y0 - c * b) / tmp;
            double tmp2 = Math.sqrt((r * r - d * d) / tmp);
            this.p1.itsX = px + tmp2 * -b;
            this.p1.itsY = py + tmp2 * a;
            this.p2.itsX = px - tmp2 * -b;
            this.p2.itsY = py - tmp2 * a;
            if (this._theI0.contains(this.p1)) {
                this._theO0.setXY(this.p1);
                this._theO0.setDefinedStatus(true);
            } else {
                this._theO0.setDefinedStatus(false);
            }
            if (this._theI0.contains(this.p2)) {
                this._theO1.setXY(this.p2);
                this._theO1.setDefinedStatus(true);
            } else {
                this._theO1.setDefinedStatus(false);
            }
        } else {
            this._theO0.setDefinedStatus(false);
            this._theO1.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

