/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Dilation;
import br.ufrj.labma.enibam.kernel.state.State;

public class GenericLineDilationConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelGenericLine theSubject;
    private KernelGenericLine theDilated;
    private KernelRatio theRatio;
    private CoorSys P1 = new CoorSys();
    private CoorSys P2 = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public GenericLineDilationConstraint(KernelPoint center, KernelGenericLine subject, KernelRatio ratio, KernelGenericLine dilated) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theDilated = dilated;
        this.theOutput[0] = this.theDilated;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getP1P2(this.P1, this.P2);
        this.theCenter.getXY(this._Center);
        Dilation.getPointDilation(this._Center, this.theRatio, this.P1);
        Dilation.getPointDilation(this._Center, this.theRatio, this.P2);
        this.theDilated.setP1P2(this.P1, this.P2);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

