/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Inversion;
import br.ufrj.labma.enibam.kernel.state.State;

public class GenericLineInversionConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelGenericLine theSubject;
    private KernelGenericLine theImage;
    private KernelRatio theRatio;
    private CoorSys P1 = new CoorSys();
    private CoorSys P2 = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public GenericLineInversionConstraint(KernelPoint center, KernelGenericLine subject, KernelRatio ratio, KernelGenericLine image) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theImage = image;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getP1P2(this.P1, this.P2);
        this.theCenter.getXY(this._Center);
        Inversion.getPointInversion(this._Center, this.theRatio, this.P1);
        Inversion.getPointInversion(this._Center, this.theRatio, this.P2);
        this.theImage.setP1P2(this.P1, this.P2);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

