/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircleLocus;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Reflection;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;
import java.util.Iterator;

public class LocusReflectionConstraint
extends AbstractConstraint {
    private KernelLocus theLocus;
    private KernelLocus theO;
    private KernelGenericLine theMirror;
    private ArrayList y;
    private CoorSys P = new CoorSys();
    private boolean isCircleLocus;

    public LocusReflectionConstraint(KernelLocus loc, KernelGenericLine mirror, KernelLocus o) {
        super(2, 1);
        this.theLocus = loc;
        this.theInput[0] = this.theLocus;
        this.theMirror = mirror;
        this.theInput[1] = this.theMirror;
        this.theO = o;
        this.theOutput[0] = this.theO;
        this.isCircleLocus = loc instanceof KernelCircleLocus;
        this.y = new ArrayList(loc.getNumberOfPoints());
        ArrayList k = (ArrayList)this.theLocus.getPointVector();
        int i = 0;
        while (i < loc.getNumberOfPoints()) {
            CoorSys P1 = (CoorSys)k.get(i);
            this.y.add(new CoorSys(P1.itsX, P1.itsY));
            ++i;
        }
        this.theO.setPointVector(this.y);
        this.theO.makeSegmentVector();
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        ArrayList k = (ArrayList)this.theLocus.getPointVector();
        this.y = (ArrayList)this.theO.getPointVector();
        ArrayList kv = (ArrayList)this.theO.getSegmentVector();
        CoorSys m = new CoorSys();
        CoorSys old = new CoorSys();
        Iterator _ks = kv.iterator();
        boolean first = true;
        int yy = this.y.size();
        int i = 0;
        while (i < yy) {
            if (this.isCircleLocus && i % 2 == 1) {
                this.P.itsX = ((CoorSys)k.get((int)i)).itsX;
                this.P.itsY = ((CoorSys)k.get((int)i)).itsY;
                m = (CoorSys)this.y.get(i);
                m.itsX = this.P.itsX;
                m.itsY = this.P.itsY;
            } else {
                this.P.itsX = ((CoorSys)k.get((int)i)).itsX;
                this.P.itsY = ((CoorSys)k.get((int)i)).itsY;
                Reflection.getPointReflection(this.P, this.theMirror);
                m = (CoorSys)this.y.get(i);
                m.itsX = this.P.itsX;
                m.itsY = this.P.itsY;
            }
            if (first) {
                first = false;
            } else {
                KernelDummySegment _kseg = (KernelDummySegment)_ks.next();
                _kseg.setP1P2(old, m);
            }
            old.itsX = m.itsX;
            old.itsY = m.itsY;
            ++i;
        }
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

