/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelLine;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class MediatrizConstraint
extends AbstractConstraint {
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();
    private CoorSys _mid = new CoorSys();
    private CoorSys _v = new CoorSys();
    private KernelSegment theSeg;
    private KernelLine theLine;

    public MediatrizConstraint(KernelSegment seg, KernelLine line) {
        super(1, 1);
        this.theSeg = seg;
        this.theInput[0] = this.theSeg;
        this.theLine = line;
        this.theOutput[0] = this.theLine;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theLine.setDefinedStatus(false);
            return;
        }
        this.theSeg.getP1P2(this._p1, this._p2);
        this._mid.itsX = (this._p1.itsX + this._p2.itsX) / 2.0;
        this._mid.itsY = (this._p1.itsY + this._p2.itsY) / 2.0;
        this._v.itsX = this._p2.itsX - this._p1.itsX;
        this._v.itsY = this._p2.itsY - this._p1.itsY;
        this._p1.itsX = this._mid.itsX + this._v.itsY;
        this._p1.itsY = this._mid.itsY - this._v.itsX;
        this._p2.itsX = this._mid.itsX - this._v.itsY;
        this._p2.itsY = this._mid.itsY + this._v.itsX;
        this.theLine.setP1P2(this._p1, this._p2);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

