/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class MiddlePointSConstraint
extends AbstractConstraint {
    private CoorSys _p1 = new CoorSys();
    private CoorSys _p2 = new CoorSys();
    private KernelSegment theSegment;
    private KernelPoint thePoint;

    public MiddlePointSConstraint(KernelSegment segment, KernelPoint point) {
        super(1, 1);
        this.theSegment = segment;
        this.theInput[0] = this.theSegment;
        this.thePoint = point;
        this.theOutput[0] = this.thePoint;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSegment.getP1P2(this._p1, this._p2);
        this._p1.itsX = (this._p1.itsX + this._p2.itsX) / 2.0;
        this._p1.itsY = (this._p1.itsY + this._p2.itsY) / 2.0;
        this.thePoint.setXY(this._p1);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

