/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.List;

public class NArcDivisionConstraint
extends AbstractConstraint {
    private CoorSys center = new CoorSys();
    private CoorSys startPoint = new CoorSys();
    private CoorSys point = new CoorSys();
    private CoorSys A = new CoorSys();
    private CoorSys B = new CoorSys();

    public NArcDivisionConstraint(KernelArc arc, List points) {
        super(1, points.size());
        this.theInput[0] = arc;
        int i = 0;
        while (i < points.size()) {
            this.theOutput[i] = (KernelElement)points.get(i);
            ++i;
        }
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this.theInput[0].getDefinedStatus()) {
            int i = 0;
            while (i < this.theOutput.length) {
                this.theOutput[i].setDefinedStatus(false);
                ++i;
            }
            return;
        }
        double angle = -((KernelArc)this.theInput[0]).getArcAngle();
        double step = angle / (double)(this.theOutput.length + 1);
        ((KernelArc)this.theInput[0]).getCenter(this.center);
        ((KernelArc)this.theInput[0]).get3Points(this.startPoint, this.A, this.B);
        int i = 0;
        while (i < this.theOutput.length) {
            ((KernelPoint)this.theOutput[i]).getXY(this.point);
            this.rotate(this.center, this.startPoint, step * (double)(i + 1), this.point);
            ((KernelPoint)this.theOutput[i]).setXY(this.point);
            this.theOutput[i].setDefinedStatus(true);
            ++i;
        }
    }

    private void rotate(CoorSys A, CoorSys B, double angle, CoorSys result) {
        double Vx = B.itsX - A.itsX;
        double Vy = B.itsY - A.itsY;
        result.itsX = A.itsX + (Vx * Math.cos(angle) - Vy * Math.sin(angle));
        result.itsY = A.itsY + (Vy * Math.cos(angle) + Vx * Math.sin(angle));
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

