/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.List;

public class NCircleDivisionConstraint
extends AbstractConstraint {
    private CoorSys center = new CoorSys();
    private CoorSys startPoint = new CoorSys();
    private CoorSys point = new CoorSys();

    public NCircleDivisionConstraint(KernelCircle circle, List points) {
        super(1, points.size());
        this.theInput[0] = circle;
        int i = 0;
        while (i < points.size()) {
            this.theOutput[i] = (KernelElement)points.get(i);
            ++i;
        }
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this.theInput[0].getDefinedStatus()) {
            int i = 0;
            while (i < this.theOutput.length) {
                this.theOutput[i].setDefinedStatus(false);
                ++i;
            }
            return;
        }
        double step = Math.PI * 2 / (double)this.theOutput.length;
        ((KernelCircle)this.theInput[0]).getCenter(this.center);
        this.startPoint.itsX = this.center.itsX + ((KernelCircle)this.theInput[0]).getRadius();
        this.startPoint.itsY = this.center.itsY;
        ((KernelPoint)this.theOutput[0]).setXY(this.startPoint);
        this.theOutput[0].setDefinedStatus(true);
        int i = 1;
        while (i < this.theOutput.length) {
            ((KernelPoint)this.theOutput[i]).getXY(this.point);
            this.rotate(this.center, this.startPoint, step * (double)i, this.point);
            ((KernelPoint)this.theOutput[i]).setXY(this.point);
            this.theOutput[i].setDefinedStatus(true);
            ++i;
        }
    }

    private void rotate(CoorSys A, CoorSys B, double angle, CoorSys result) {
        double Vx = B.itsX - A.itsX;
        double Vy = B.itsY - A.itsY;
        result.itsX = A.itsX + (Vx * Math.cos(angle) - Vy * Math.sin(angle));
        result.itsY = A.itsY + (Vy * Math.cos(angle) + Vx * Math.sin(angle));
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

