/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelElement;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.List;

public class NSegmentDivisionConstraint
extends AbstractConstraint {
    private CoorSys A = new CoorSys();
    private CoorSys B = new CoorSys();
    private CoorSys C = new CoorSys();

    public NSegmentDivisionConstraint(KernelSegment segment, List points) {
        super(1, points.size());
        this.theInput[0] = segment;
        int i = 0;
        while (i < points.size()) {
            this.theOutput[i] = (KernelElement)points.get(i);
            ++i;
        }
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this.theInput[0].getDefinedStatus()) {
            int i = 0;
            while (i < this.theOutput.length) {
                this.theOutput[i].setDefinedStatus(false);
                ++i;
            }
            return;
        }
        ((KernelSegment)this.theInput[0]).getP1P2(this.A, this.B);
        this.C.itsX = (this.B.itsX - this.A.itsX) / (double)(this.theOutput.length + 1);
        this.C.itsY = (this.B.itsY - this.A.itsY) / (double)(this.theOutput.length + 1);
        ((KernelPoint)this.theOutput[0]).setXY(this.A.itsX + this.C.itsX, this.A.itsY + this.C.itsY);
        this.theOutput[0].setDefinedStatus(true);
        int i = 1;
        while (i < this.theOutput.length) {
            ((KernelPoint)this.theOutput[i - 1]).getXY(this.A);
            ((KernelPoint)this.theOutput[i]).setXY(this.A.itsX + this.C.itsX, this.A.itsY + this.C.itsY);
            this.theOutput[i].setDefinedStatus(true);
            ++i;
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

