/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CentralSymmetry;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class PointCentralSymmetryConstraint
extends AbstractConstraint {
    private KernelPoint theSubject;
    private KernelPoint theImage;
    private KernelPoint theMirror;
    private CoorSys _p = new CoorSys();
    private CoorSys _mirror = new CoorSys();

    public PointCentralSymmetryConstraint(KernelPoint subject, KernelPoint mirror, KernelPoint image) {
        super(2, 1);
        this.theSubject = subject;
        this.theInput[0] = this.theSubject;
        this.theMirror = mirror;
        this.theInput[1] = this.theMirror;
        this.theImage = image;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getXY(this._p);
        this.theMirror.getXY(this._mirror);
        CentralSymmetry.getPointCentralSymmetry(this._p, this._mirror);
        this.theImage.setXY(this._p);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

