/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class PointInArcConstraint
extends AbstractConstraint {
    private MathVector itsRelativePosition = new MathVector();
    private KernelArc _theI0;
    private KernelPoint _theI1;
    private KernelPoint _theO0;
    private double lastAngReason = 0.0;
    private int isOverExtremePt = 0;

    public PointInArcConstraint(KernelArc i, KernelPoint o) {
        super(2, 1);
        this._theI0 = i;
        this.theInput[0] = this._theI0;
        this._theI1 = this._theO0 = o;
        this.theOutput[0] = this._theO0;
        this.theInput[1] = this._theO0;
        this.setup();
    }

    private void setup() {
        boolean _onarc;
        if (!this._theI0.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return;
        }
        this._theO0.setDefinedStatus(true);
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        this.itsRelativePosition.unitario().productByNumber(radius);
        double _vectorx = this.itsRelativePosition.getX();
        double _vectory = this.itsRelativePosition.getY();
        double _startAngle = this._theI0.getStartingAngle();
        double _arcAngle = this._theI0.getArcAngle();
        double _vecrx = this.rotateX(_vectorx, _vectory, -_startAngle);
        double _vecry = this.rotateY(_vectorx, _vectory, -_startAngle);
        double _ang_r = this.angle(_vecrx, _vecry);
        if (_arcAngle > 0.0) {
            _onarc = _ang_r <= _arcAngle;
        } else {
            boolean bl = _onarc = (_ang_r = Math.PI * 2 - _ang_r) <= -_arcAngle;
        }
        if (!_onarc) {
            double _v1x = this.rotateX(radius, 0.0, -_startAngle);
            double _v1y = this.rotateY(radius, 0.0, -_startAngle);
            double _v2x = this.rotateX(radius, 0.0, -_startAngle - _arcAngle);
            double _v2y = this.rotateY(radius, 0.0, -_startAngle - _arcAngle);
            if (this.dist(_v1x, _v1y, _vectorx, _vectory) < this.dist(_v2x, _v2y, _vectorx, _vectory)) {
                this.itsRelativePosition.setXY(_v1x, _v1y);
                this.isOverExtremePt = 1;
            } else {
                this.itsRelativePosition.setXY(_v2x, _v2y);
                this.isOverExtremePt = 2;
            }
        } else {
            this.lastAngReason = _arcAngle > 0.0 ? _ang_r / _arcAngle : -_ang_r / _arcAngle;
            this.isOverExtremePt = 0;
        }
        this._theO0.setXY(x0 + this.itsRelativePosition.getX(), y0 + this.itsRelativePosition.getY());
    }

    @Override
    public void calculate() {
        if (!this._theI0.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return;
        }
        this._theO0.setDefinedStatus(true);
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        double _startAngle = this._theI0.getStartingAngle();
        double _arcAngle = this._theI0.getArcAngle();
        double _v1x = this.rotateX(radius, 0.0, -_startAngle);
        double _v1y = this.rotateY(radius, 0.0, -_startAngle);
        if (this.isOverExtremePt == 0) {
            double _newAngle = this.lastAngReason * _arcAngle;
            double p1x = this.rotateX(radius, 0.0, -_startAngle - _newAngle);
            double p1y = this.rotateY(radius, 0.0, -_startAngle - _newAngle);
            this.itsRelativePosition.setXY(p1x, p1y);
        } else if (this.isOverExtremePt == 1) {
            this.itsRelativePosition.setXY(_v1x, _v1y);
        } else {
            double _v2x = this.rotateX(radius, 0.0, -_startAngle - _arcAngle);
            double _v2y = this.rotateY(radius, 0.0, -_startAngle - _arcAngle);
            this.itsRelativePosition.setXY(_v2x, _v2y);
        }
        this._theO0.setXY(x0 + this.itsRelativePosition.getX(), y0 + this.itsRelativePosition.getY());
    }

    @Override
    public boolean isOk(State P1) {
        boolean _onarc;
        PointState P = (PointState)P1;
        if (!this._theI1.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return false;
        }
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        double x = P.itsX;
        double y = P.itsY;
        double module = Math.sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0));
        double _vectorx = (x - x0) * (radius / module);
        double _vectory = (y - y0) * (radius / module);
        P.itsX = x0 + _vectorx;
        P.itsY = y0 + _vectory;
        this.itsRelativePosition.setXY(_vectorx, _vectory);
        double _startAngle = this._theI0.getStartingAngle();
        double _arcAngle = this._theI0.getArcAngle();
        double _vecrx = this.rotateX(_vectorx, _vectory, -_startAngle);
        double _vecry = this.rotateY(_vectorx, _vectory, -_startAngle);
        double _ang_r = this.angle(_vecrx, _vecry);
        if (_arcAngle > 0.0) {
            _onarc = _ang_r <= _arcAngle;
        } else {
            boolean bl = _onarc = (_ang_r = Math.PI * 2 - _ang_r) <= -_arcAngle;
        }
        if (!_onarc) {
            double _v1x = this.rotateX(radius, 0.0, -_startAngle);
            double _v1y = this.rotateY(radius, 0.0, -_startAngle);
            double _v2x = this.rotateX(radius, 0.0, -_startAngle - _arcAngle);
            double _v2y = this.rotateY(radius, 0.0, -_startAngle - _arcAngle);
            if (this.dist(_v1x, _v1y, _vectorx, _vectory) < this.dist(_v2x, _v2y, _vectorx, _vectory)) {
                P.itsX = x0 + _v1x;
                P.itsY = y0 + _v1y;
                this.itsRelativePosition.setXY(_v1x, _v1y);
                this.isOverExtremePt = 1;
            } else {
                P.itsX = x0 + _v2x;
                P.itsY = y0 + _v2y;
                this.itsRelativePosition.setXY(_v2x, _v2y);
                this.isOverExtremePt = 2;
            }
        } else {
            this.isOverExtremePt = 0;
            this.lastAngReason = _arcAngle > 0.0 ? _ang_r / _arcAngle : -_ang_r / _arcAngle;
        }
        return true;
    }

    private double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private double rotateX(double vx, double vy, double theta) {
        return vx * Math.cos(theta) + vy * Math.sin(theta);
    }

    private double rotateY(double vx, double vy, double theta) {
        return vx * Math.sin(theta) - vy * Math.cos(theta);
    }

    private double angle(double v2x, double v2y) {
        double innerP = v2x;
        double cosang = innerP / Math.sqrt(v2x * v2x + v2y * v2y);
        double ang = Math.acos(cosang);
        if (v2y < 0.0) {
            ang = Math.PI * 2 - ang;
        }
        return ang;
    }
}

