/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelAxes;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Matrix;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class PointInAxesConstraint
extends AbstractConstraint {
    private KernelAxes _theI0;
    private KernelPoint _theI1;
    private KernelPoint _theO0;

    public PointInAxesConstraint(KernelPoint point, KernelAxes axes, KernelPoint point2) {
        super(2, 1);
        this._theI0 = axes;
        this.theInput[0] = this._theI0;
        this._theI1 = this._theO0 = point;
        this.theOutput[0] = this._theO0;
        this.theInput[1] = this._theO0;
        this.calculate();
    }

    @Override
    public void calculate() {
        CoorSys p0 = new CoorSys();
        CoorSys p1 = new CoorSys();
        CoorSys p2 = new CoorSys();
        CoorSys p3 = new CoorSys();
        this._theI0.getOrigin(p0);
        this._theI0.getP1(p1);
        this._theI0.getP2(p2);
        this._theO0.getXY(p3);
        MathVector vector1 = new MathVector(p0, p1);
        MathVector vector2 = new MathVector(p0, p2);
        MathVector vector3 = new MathVector(p0, p3);
        double[][] elements = new double[2][2];
        elements[0][0] = vector1.getX();
        elements[1][0] = vector1.getY();
        elements[0][1] = vector2.getX();
        elements[1][1] = vector2.getY();
        Matrix matriz = new Matrix(2, elements);
        Matrix inversa = matriz.inverse();
        double fx = inversa.elementAt(1, 1) * vector3.getX() + inversa.elementAt(2, 1) * vector3.getY();
        double fy = inversa.elementAt(1, 2) * vector3.getX() + inversa.elementAt(2, 2) * vector3.getY();
        CoorSys pf = new CoorSys(fx, fy);
        this._theO0.setXY(pf);
    }

    @Override
    public boolean isOk(State P1) {
        PointState P = (PointState)P1;
        CoorSys p0 = new CoorSys();
        CoorSys p1 = new CoorSys();
        CoorSys p2 = new CoorSys();
        CoorSys p3 = new CoorSys();
        this._theI0.getOrigin(p0);
        this._theI0.getP1(p1);
        this._theI0.getP2(p2);
        this._theO0.getXY(p3);
        MathVector vector1 = new MathVector(p0, p1);
        MathVector vector2 = new MathVector(p0, p2);
        MathVector vector3 = new MathVector(p0, p3);
        double[][] elements = new double[2][2];
        elements[0][0] = vector1.getX();
        elements[1][0] = vector1.getY();
        elements[0][1] = vector2.getX();
        elements[1][1] = vector2.getY();
        Matrix matriz = new Matrix(2, elements);
        Matrix inversa = matriz.inverse();
        double fx = inversa.elementAt(1, 1) * vector3.getX() + inversa.elementAt(2, 1) * vector3.getY();
        double fy = inversa.elementAt(1, 2) * vector3.getX() + inversa.elementAt(2, 2) * vector3.getY();
        CoorSys pf = new CoorSys(fx, fy);
        this._theO0.setXY(pf);
        return true;
    }
}

