/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class PointInCircleConstraint
extends AbstractConstraint {
    private MathVector itsRelativePosition = new MathVector();
    private KernelCircle _theI0;
    private KernelPoint _theI1;
    private KernelPoint _theO0;

    public PointInCircleConstraint(KernelCircle i, KernelPoint o) {
        super(2, 1);
        this._theI0 = i;
        this.theInput[0] = this._theI0;
        this._theI1 = this._theO0 = o;
        this.theOutput[0] = this._theO0;
        this.theInput[1] = this._theO0;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this._theI0.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return;
        }
        this._theO0.setDefinedStatus(true);
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        this.itsRelativePosition.unitario().productByNumber(radius);
        this._theO0.setXY(x0 + this.itsRelativePosition.getX(), y0 + this.itsRelativePosition.getY());
    }

    @Override
    public boolean isOk(State P1) {
        PointState P = (PointState)P1;
        if (!this._theI1.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return false;
        }
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        double x = P.itsX;
        double y = P.itsY;
        double module = Math.sqrt((x - x0) * (x - x0) + (y - y0) * (y - y0));
        double _vectorx = (x - x0) * (radius / module);
        double _vectory = (y - y0) * (radius / module);
        P.itsX = x0 + _vectorx;
        P.itsY = y0 + _vectory;
        this.itsRelativePosition.setXY(_vectorx, _vectory);
        return true;
    }
}

