/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelLocus;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummyLine;
import br.ufrj.labma.enibam.kernel.dummy.KernelDummySegment;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.ArrayList;

public class PointInLocusConstraint
extends AbstractConstraint {
    ArrayList theSegList;
    KernelPoint thePoint;
    KernelLocus theLocus;
    int segindex;
    CoorSys _closer = new CoorSys();
    CoorSys _pos = new CoorSys();
    CoorSys _c1 = new CoorSys();
    CoorSys _c2 = new CoorSys();
    CoorSys _p1;
    KernelDummyLine _l1;
    MathVector _v1;
    boolean first;
    CoorSys cs = new CoorSys();
    int SEG_TOL = 0;
    int RAZAO = 20;

    public PointInLocusConstraint(KernelLocus l, KernelPoint p) {
        super(2, 1);
        this.theInput[0] = l;
        this.theInput[1] = this.theOutput[0] = p;
        this.theLocus = l;
        this.thePoint = p;
        this.theSegList = (ArrayList)l.getSegmentVector();
        this._p1 = new CoorSys(p.getX(), p.getY());
        this._l1 = new KernelDummyLine(0.0, 0.0, 1.0, 1.0);
        this._v1 = new MathVector(0.0, 0.0, 1.0, 1.0);
        this.first = true;
        this.calculate();
    }

    @Override
    public void calculate() {
        ((KernelPoint)this.theOutput[0]).setXY(this.whichIsCloser());
    }

    @Override
    public boolean isOk(State st) {
        PointState _st = (PointState)st;
        this.cs.itsX = _st.itsX;
        this.cs.itsY = _st.itsY;
        this.cs.itsDefinedStatus = _st.itsDefinedStatus;
        if (this.first) {
            this.first = false;
            this.SEG_TOL = this.theSegList.size() / this.RAZAO;
            this.thePoint.setXY(this.cs.itsX, this.cs.itsY);
            this.which1();
            return true;
        }
        int _m = this.theSegList.size();
        boolean _b1 = this.segindex > this.SEG_TOL && this.segindex + this.SEG_TOL < _m;
        int _i = 0;
        while (_i < _m) {
            KernelDummySegment _s = (KernelDummySegment)this.theSegList.get(_i);
            if (_b1) {
                if (this.segindex - _i <= this.SEG_TOL) {
                    if (_i - this.segindex > this.SEG_TOL) break;
                }
            } else {
                _s.getVector(this._v1);
                this._v1.orthogonal();
                this._p1.itsX = this.cs.itsX - 5.0 * this._v1.getX();
                this._p1.itsY = this.cs.itsY - 5.0 * this._v1.getY();
                this._l1.setP1P2(this.cs, this._p1);
                Intersection.getIntersection(_s, this._l1, this._p1);
                if (this.contain(_s, this._p1)) {
                    boolean bl = _b1 = !(this.segindex >= this.SEG_TOL && this.segindex + this.SEG_TOL <= _m || _i + this.SEG_TOL <= _m && _i >= this.SEG_TOL);
                    if (_b1 || Math.abs(this.segindex - _i) < this.SEG_TOL) {
                        this.segindex = _i;
                        _st.itsX = this._p1.itsX;
                        _st.itsY = this._p1.itsY;
                        _st.itsDefinedStatus = this._p1.itsDefinedStatus;
                        return true;
                    }
                }
            }
            ++_i;
        }
        return false;
    }

    private CoorSys which1() {
        double _d1 = 1000000.0;
        double _d2 = 0.0;
        this.thePoint.getXY(this._pos);
        this.thePoint.getXY(this._closer);
        int _l = this.theSegList.size();
        int _i = 0;
        while (_i < _l) {
            KernelDummySegment _s = (KernelDummySegment)this.theSegList.get(_i);
            this.avg(_s, this._p1);
            _d2 = Distance.getDistance(this._p1, this._pos);
            if (_d2 < _d1) {
                _d1 = _d2;
                this._closer.itsX = this._p1.itsX;
                this._closer.itsY = this._p1.itsY;
                this.segindex = this.theSegList.indexOf(_s);
            }
            ++_i;
        }
        return this._closer;
    }

    private void avg(KernelDummySegment s, CoorSys p) {
        s.getP1P2(this._c1, this._c2);
        p.itsX = 0.5 * (this._c1.itsX + this._c2.itsX);
        p.itsY = 0.5 * (this._c1.itsY + this._c2.itsY);
    }

    private CoorSys whichIsCloser() {
        KernelDummySegment _s = (KernelDummySegment)this.theSegList.get(this.segindex);
        this.avg(_s, this._closer);
        return this._closer;
    }

    private boolean contain(KernelDummySegment d, CoorSys i) {
        d.getP1P2(this._c1, this._c2);
        double m = (i.itsX - this._c1.itsX) / (this._c2.itsX - this._c1.itsX);
        return m < 1.0 && m > 0.0;
    }
}

