/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.state.PointState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class PointInsideCircleConstraint
extends AbstractConstraint {
    private MathVector itsRelativePosition = new MathVector();
    private double itsOldRadius;
    private KernelCircle _theI0;
    private KernelPoint _theI1;
    private KernelPoint _theO0;

    public PointInsideCircleConstraint(KernelCircle i, KernelPoint o) {
        super(2, 1);
        this._theI0 = i;
        this.theInput[0] = this._theI0;
        this._theI1 = this._theO0 = o;
        this.theOutput[0] = this._theO0;
        this.theInput[1] = this._theO0;
        this.itsOldRadius = this._theI0.getRadius();
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this._theI0.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return;
        }
        this._theO0.setDefinedStatus(true);
        double radius = this._theI0.getRadius();
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        this.itsRelativePosition.productByNumber(radius / this.itsOldRadius);
        this.itsOldRadius = radius;
        this._theO0.setXY(x0 + this.itsRelativePosition.getX(), y0 + this.itsRelativePosition.getY());
    }

    @Override
    public boolean isOk(State P1) {
        double y0;
        double y;
        PointState P = (PointState)P1;
        if (!this._theI1.getDefinedStatus()) {
            this._theO0.setDefinedStatus(false);
            return false;
        }
        double radius = this._theI0.getRadius();
        double x = P.itsX;
        double x0 = this._theI0.getCenterX();
        double module = Math.sqrt((x - x0) * (x - x0) + ((y = P.itsY) - (y0 = this._theI0.getCenterY())) * (y - y0));
        if (module < radius) {
            this.itsRelativePosition.setXY(x - x0, y - y0);
            this.itsOldRadius = radius;
            return true;
        }
        double _vectorx = (x - x0) * (radius / module);
        double _vectory = (y - y0) * (radius / module);
        P.itsX = x0 + _vectorx;
        P.itsY = y0 + _vectory;
        this.itsRelativePosition.setXY(_vectorx, _vectory);
        this.itsOldRadius = radius;
        return true;
    }
}

