/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Inversion2;
import br.ufrj.labma.enibam.kernel.state.State;

public class PointInversion2Constraint
extends AbstractConstraint {
    private KernelPoint theSubject;
    private KernelPoint theImage;
    private KernelCircle theCircle;
    private CoorSys P = new CoorSys();
    private CoorSys _P = new CoorSys();
    private CoorSys center = new CoorSys();

    public PointInversion2Constraint(KernelPoint subject, KernelCircle circle, KernelPoint inverted) {
        super(2, 1);
        this.theCircle = circle;
        this.theInput[0] = this.theCircle;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theImage = inverted;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getXY(this.P);
        this.theCircle.getCenter(this.center);
        if (this.P.itsX == this.center.itsX && this.P.itsY == this.center.itsY) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        Inversion2.getPointInversion(this.theCircle, this.P, this._P);
        this.theImage.setXY(this._P);
        if (this._P.itsX == (double)Inversion2.MAXINV && this._P.itsY == (double)Inversion2.MAXINV) {
            this.theOutput[0].setDefinedStatus(false);
        } else {
            this.theOutput[0].setDefinedStatus(true);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

