/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Inversion;
import br.ufrj.labma.enibam.kernel.state.State;

public class PointInversionConstraint
extends AbstractConstraint {
    private KernelPoint theCenter;
    private KernelPoint theSubject;
    private KernelPoint theImage;
    private KernelRatio theRatio;
    private CoorSys P = new CoorSys();
    private CoorSys _Center = new CoorSys();

    public PointInversionConstraint(KernelPoint center, KernelPoint subject, KernelRatio ratio, KernelPoint inverted) {
        super(3, 1);
        this.theCenter = center;
        this.theInput[0] = this.theCenter;
        this.theSubject = subject;
        this.theInput[1] = this.theSubject;
        this.theRatio = ratio;
        this.theInput[2] = this.theRatio;
        this.theImage = inverted;
        this.theOutput[0] = this.theImage;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theSubject.getXY(this.P);
        this.theCenter.getXY(this._Center);
        Inversion.getPointInversion(this._Center, this.theRatio, this.P);
        this.theImage.setXY(this.P);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

