/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelAxes;
import br.ufrj.labma.enibam.kernel.KernelCoordinateXY;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.CoordinateState;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class PolarCoordinateConstraint
extends AbstractConstraint {
    private KernelAxes _theI0;
    private KernelPoint _theI1;
    private KernelCoordinateXY _theO0;

    public PolarCoordinateConstraint(KernelPoint point, KernelAxes axes, KernelCoordinateXY point2) {
        super(2, 1);
        this._theI0 = axes;
        this.theInput[0] = this._theI0;
        this._theI1 = point;
        this.theInput[1] = this._theI1;
        this._theO0 = point2;
        this.theOutput[0] = this._theO0;
        this.calculate();
    }

    @Override
    public void calculate() {
        CoorSys P0 = new CoorSys();
        CoorSys P1 = new CoorSys();
        CoorSys P2 = new CoorSys();
        CoorSys P3 = new CoorSys();
        this._theI0.getOrigin(P0);
        this._theI0.getP1(P1);
        this._theI0.getP2(P2);
        this._theI1.getXY(P3);
        MathVector vector0 = new MathVector(P0, P1);
        MathVector vector1 = new MathVector(P0, P2);
        MathVector vector2 = new MathVector(P0, P3);
        double[][] elements = new double[2][2];
        double[][] elements2 = new double[2][2];
        elements[0][0] = vector0.getX();
        elements[0][1] = vector0.getY();
        elements[1][0] = vector1.getX();
        elements[1][1] = vector1.getY();
        double det = elements[0][0] * elements[1][1] - elements[1][0] * elements[0][1];
        elements2[0][0] = elements[1][1] / det;
        elements2[1][0] = -elements[0][1] / det;
        elements2[0][1] = -elements[1][0] / det;
        elements2[1][1] = elements[0][0] / det;
        double px = elements2[0][0] * vector2.getX() + elements2[0][1] * vector2.getY();
        double py = elements2[1][0] * vector2.getX() + elements2[1][1] * vector2.getY();
        double fr = Math.pow(px * px + py * py, 0.5);
        double ft = 0.0;
        ft = py > 0.0 ? 360.0 * Math.atan2(py, px) / 6.28 : 360.0 * (1.0 + Math.atan2(py, px) / 6.28);
        CoordinateState polar = new CoordinateState();
        polar.itsX = fr;
        polar.itsY = ft;
        this._theO0.changeState(polar);
        this._theO0.setCoordinate(fr, ft);
    }

    @Override
    public boolean isOk(State _state) {
        CoorSys P0 = new CoorSys();
        CoorSys P1 = new CoorSys();
        CoorSys P2 = new CoorSys();
        CoorSys P3 = new CoorSys();
        this._theI0.getOrigin(P0);
        this._theI0.getP1(P1);
        this._theI0.getP2(P2);
        this._theI1.getXY(P3);
        MathVector vector0 = new MathVector(P0, P1);
        MathVector vector1 = new MathVector(P0, P2);
        MathVector vector2 = new MathVector(P0, P3);
        double[][] elements = new double[2][2];
        double[][] elements2 = new double[2][2];
        elements[0][0] = vector0.getX();
        elements[0][1] = vector0.getY();
        elements[1][0] = vector1.getX();
        elements[1][1] = vector1.getY();
        double det = elements[0][0] * elements[1][1] - elements[1][0] * elements[0][1];
        elements2[0][0] = elements[1][1] / det;
        elements2[1][0] = -elements[0][1] / det;
        elements2[0][1] = -elements[1][0] / det;
        elements2[1][1] = elements[0][0] / det;
        double px = elements2[0][0] * vector2.getX() + elements2[0][1] * vector2.getY();
        double py = elements2[1][0] * vector2.getX() + elements2[1][1] * vector2.getY();
        double fr = Math.pow(px * px + py * py, 0.5);
        double ft = 0.0;
        ft = py > 0.0 ? 360.0 * Math.atan2(py, px) / 6.28 : 360.0 * (1.0 + Math.atan2(py, px) / 6.28);
        System.out.println(String.valueOf(Double.toString(ft)) + " " + Double.toString(fr));
        ((CoordinateState)_state).itsX = fr;
        ((CoordinateState)_state).itsY = ft;
        return true;
    }
}

