/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPolygon;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Reflection;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.ArrayList;

public class PolygonReflectionConstraint
extends AbstractConstraint {
    private KernelPolygon thePolygon;
    private KernelPolygon theO;
    private KernelGenericLine theMirror;
    private CoorSys P = new CoorSys();

    public PolygonReflectionConstraint(KernelPolygon pol, KernelGenericLine mirror, KernelPolygon o) {
        super(2, 1);
        this.thePolygon = pol;
        this.theInput[0] = this.thePolygon;
        this.theMirror = mirror;
        this.theInput[1] = this.theMirror;
        this.theO = o;
        this.theOutput[0] = this.theO;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        ArrayList k = (ArrayList)this.thePolygon.getPoints();
        ArrayList<CoorSys> x = new ArrayList<CoorSys>(k.size());
        int i = 0;
        while (i < k.size()) {
            this.P.itsX = ((CoorSys)k.get((int)i)).itsX;
            this.P.itsY = ((CoorSys)k.get((int)i)).itsY;
            Reflection.getPointReflection(this.P, this.theMirror);
            x.add(new CoorSys(this.P.itsX, this.P.itsY));
            ++i;
        }
        this.theO.setPoints(x);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

