/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class Ratio3PConstraint
extends AbstractConstraint {
    private CoorSys A = new CoorSys();
    private CoorSys B = new CoorSys();
    private CoorSys C = new CoorSys();
    private KernelPoint _theI0;
    private KernelPoint _theI1;
    private KernelPoint _theI2;
    private KernelRatio _theO0;
    private static final double TOLERANCE = 1.0E-4;

    public Ratio3PConstraint(KernelPoint p1, KernelPoint p2, KernelPoint p3, KernelRatio o1) {
        super(3, 1);
        this._theI0 = p1;
        this.theInput[0] = this._theI0;
        this._theI1 = p2;
        this.theInput[1] = this._theI1;
        this._theI2 = p3;
        this.theInput[2] = this._theI2;
        this._theO0 = o1;
        this.theOutput[0] = this._theO0;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this._theO0.setDefinedStatus(false);
            return;
        }
        this._theO0.setDefinedStatus(true);
        this._theI0.getXY(this.A);
        this._theI1.getXY(this.B);
        this._theI2.getXY(this.C);
        double x1 = this.B.itsX - this.A.itsX;
        double y1 = this.B.itsY - this.A.itsY;
        double x2 = this.C.itsX - this.A.itsX;
        double y2 = this.C.itsY - this.A.itsY;
        if (Math.abs(x1) <= 1.0E-4 && Math.abs(y1) <= 1.0E-4) {
            this._theO0.setDefinedStatus(false);
        } else if (x1 != 0.0 && Math.abs(y1) <= 1.0E-4) {
            if (Math.abs(y2) <= 1.0E-4) {
                this._theO0.setRatio(x2 / x1);
            } else {
                this._theO0.setDefinedStatus(false);
            }
        } else if (Math.abs(x1) <= 1.0E-4 && y1 != 0.0) {
            if (Math.abs(x2) <= 1.0E-4) {
                this._theO0.setRatio(y2 / y1);
            } else {
                this._theO0.setDefinedStatus(false);
            }
        } else {
            double rx = x2 / x1;
            double ry = y2 / y1;
            if (Math.abs(rx - ry) <= 1.0E-4) {
                this._theO0.setRatio(rx);
            } else {
                this._theO0.setDefinedStatus(false);
            }
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

