/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelGenericLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.state.State;

public class SmartArcGenericLineIntersectionConstraint
extends AbstractConstraint {
    private CoorSys p1 = new CoorSys();
    private CoorSys p2 = new CoorSys();
    private CoorSys _p = new CoorSys();
    private KernelArc _theI0;
    private KernelGenericLine _theI1;
    private KernelPoint _theI2;
    private KernelPoint _theO0;

    public SmartArcGenericLineIntersectionConstraint(KernelArc i1, KernelGenericLine i2, KernelPoint i3, KernelPoint o1) {
        super(3, 1);
        this._theI0 = i1;
        this.theInput[0] = this._theI0;
        this._theI1 = i2;
        this.theInput[1] = this._theI1;
        this._theI2 = i3;
        this.theInput[2] = this._theI2;
        this._theO0 = o1;
        this.theOutput[0] = this._theO0;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (!this._theI0.getDefinedStatus() || !this._theI1.getDefinedStatus()) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        double x0 = this._theI0.getCenterX();
        double y0 = this._theI0.getCenterY();
        double r = this._theI0.getRadius();
        double a = this._theI1.getA();
        double b = this._theI1.getB();
        double c = this._theI1.getC();
        double tmp = a * a + b * b;
        double d = Math.abs(a * x0 + b * y0 + c) / Math.sqrt(tmp);
        if (d <= r) {
            double px = (b * b * x0 - b * a * y0 - c * a) / tmp;
            double py = (-a * b * x0 + a * a * y0 - c * b) / tmp;
            double tmp2 = Math.sqrt((r * r - d * d) / tmp);
            this.p1.itsX = px + tmp2 * -b;
            this.p1.itsY = py + tmp2 * a;
            this.p2.itsX = px - tmp2 * -b;
            this.p2.itsY = py - tmp2 * a;
            this._theI2.getXY(this._p);
            double d1 = Distance.getDistance2(this.p1, this._p);
            double d2 = Distance.getDistance2(this.p2, this._p);
            CoorSys ponto = d1 <= d2 || !this._theI2.getDefinedStatus() ? this.p2 : this.p1;
            if (this._theI0.contains(ponto) && this._theI1.contains(ponto)) {
                this._theO0.setXY(ponto);
                this._theO0.setDefinedStatus(true);
            } else {
                this._theO0.setDefinedStatus(false);
            }
        } else {
            this._theO0.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

