/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelLine;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.state.State;

public class TangentConstraint
extends AbstractConstraint {
    private KernelCircle theCircle;
    private KernelPoint thePoint;
    private KernelLine theLineTangent1;
    private KernelLine theLineTangent2;
    private CoorSys V = new CoorSys();
    private CoorSys P1 = new CoorSys();
    private CoorSys P2 = new CoorSys();
    private static final double delta = 1.0;

    public TangentConstraint(KernelCircle c, KernelPoint p, KernelLine l1, KernelLine l2) {
        super(2, 2);
        this.theCircle = c;
        this.theInput[0] = this.theCircle;
        this.thePoint = p;
        this.theInput[1] = this.thePoint;
        this.theLineTangent1 = l1;
        this.theOutput[0] = this.theLineTangent1;
        this.theLineTangent2 = l2;
        this.theOutput[1] = this.theLineTangent2;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.theOutput[0].setDefinedStatus(false);
            this.theOutput[1].setDefinedStatus(false);
            return;
        }
        this.V.itsX = this.thePoint.getX() - this.theCircle.getCenterX();
        this.V.itsY = this.thePoint.getY() - this.theCircle.getCenterY();
        double dist = Math.sqrt(this.V.itsX * this.V.itsX + this.V.itsY * this.V.itsY);
        if (this.theCircle.getRadius() <= 1.0 && this.theCircle.getRadius() >= -1.0) {
            this.theOutput[0].setDefinedStatus(false);
            this.theOutput[1].setDefinedStatus(false);
            return;
        }
        if (dist > this.theCircle.getRadius() + 1.0) {
            this.theCircle.getCenter(this.P1);
            this.thePoint.getXY(this.P2);
            this.V.itsX = (this.P1.itsX + this.P2.itsX) / 2.0;
            this.V.itsY = (this.P1.itsY + this.P2.itsY) / 2.0;
            dist = Math.sqrt((this.P1.itsX - this.V.itsX) * (this.P1.itsX - this.V.itsX) + (this.P1.itsY - this.V.itsY) * (this.P1.itsY - this.V.itsY));
            double d = Distance.getDistance(this.V.itsX, this.V.itsY, this.P1.itsX, this.P2.itsY);
            double r2 = this.theCircle.getRadius();
            double u = (d * d + dist * dist - r2 * r2) / (2.0 * d);
            double v = -1.0 * Math.sqrt(dist * dist - u * u);
            double _V = Math.sqrt(dist * dist - u * u);
            double ix = this.V.itsX + ((this.P1.itsX - this.V.itsX) * u + (this.P1.itsY - this.V.itsY) * v) / d;
            double iy = this.V.itsY - ((this.V.itsY - this.P1.itsY) * u + (this.P1.itsX - this.V.itsX) * v) / d;
            double Ix = this.V.itsX + ((this.P1.itsX - this.V.itsX) * u + (this.P1.itsY - this.V.itsY) * _V) / d;
            double Iy = this.V.itsY - ((this.V.itsY - this.P1.itsY) * u + (this.P1.itsX - this.V.itsX) * _V) / d;
            this.P1.itsX = ix;
            this.P1.itsY = iy;
            this.theLineTangent1.setP1P2(this.P2, this.P1);
            this.P1.itsX = Ix;
            this.P1.itsY = Iy;
            this.theLineTangent2.setP1P2(this.P2, this.P1);
            this.theOutput[0].setDefinedStatus(true);
            this.theOutput[1].setDefinedStatus(true);
            return;
        }
        if (this.theCircle.getRadius() + 1.0 >= dist && dist >= this.theCircle.getRadius() - 1.0) {
            dist = this.V.itsX;
            this.V.itsX = this.V.itsY;
            this.V.itsY = -dist;
            this.theLineTangent1.setP1P2(this.thePoint.getX() + this.V.itsX, this.thePoint.getY() + this.V.itsY, this.thePoint.getX(), this.thePoint.getY());
            this.theOutput[0].setDefinedStatus(true);
            this.theOutput[1].setDefinedStatus(false);
            return;
        }
        this.theOutput[0].setDefinedStatus(false);
        this.theOutput[1].setDefinedStatus(false);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

