/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint;

import br.ufrj.labma.enibam.kernel.KernelRatio;
import br.ufrj.labma.enibam.kernel.KernelVector;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class VectorMultiplyedByNumberConstraint
extends AbstractConstraint {
    KernelVector theVector1;
    KernelVector theVector2;
    KernelRatio theRatio;
    CoorSys P1 = new CoorSys();
    CoorSys P2 = new CoorSys();

    public VectorMultiplyedByNumberConstraint(KernelVector v1, KernelRatio n, KernelVector v2) {
        super(2, 1);
        this.theVector1 = v1;
        this.theInput[0] = this.theVector1;
        this.theRatio = n;
        this.theInput[1] = this.theRatio;
        this.theVector2 = v2;
        this.theOutput[0] = this.theVector2;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined() || this.theRatio.getRatio() == 0.0) {
            this.theOutput[0].setDefinedStatus(false);
            return;
        }
        this.theVector1.getP1P2(this.P1, this.P2);
        double dx = this.P2.itsX - this.P1.itsX;
        double dy = this.P2.itsY - this.P1.itsY;
        this.P2.itsX = this.P1.itsX + dx * this.theRatio.getRatio();
        this.P2.itsY = this.P1.itsY + dy * this.theRatio.getRatio();
        this.theVector2.setP1P2(this.P1, this.P2);
        this.theOutput[0].setDefinedStatus(true);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

