/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;

public class HypCircleCPConstraint
extends AbstractConstraint {
    private KernelPoint _O;
    private KernelPoint _M;
    private KernelCircle _C;
    private KernelCircle CH;

    public HypCircleCPConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelCircle o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._O = p0;
        this.theInput[1] = this._O;
        this._M = p1;
        this.theInput[2] = this._M;
        this.CH = o1;
        this.theOutput[0] = this.CH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7005), "br.ufrj.labma.enibam.kernel.KernelCircle2P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypCircleCPConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.CH.setDefinedStatus(false);
            return;
        }
        this.CH.setDefinedStatus(true);
        CoorSys O = new CoorSys(this._O.getX(), this._O.getY());
        CoorSys M = new CoorSys(this._M.getX(), this._M.getY());
        CoorSys OH = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double RH = this._C.getRadius();
        CoorSys OC = new CoorSys();
        if (NonEuclidMath.poincareCircleEuclidianCenter(O, M, OH, RH, OC)) {
            this.CH.setCenterPoint(OC, M);
        } else {
            this.CH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

