/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.Vector;

public class HypComPerpConstraint
extends AbstractConstraint {
    private KernelArc _D1;
    private KernelArc _D2;
    private KernelCircle _C;
    private KernelArc RH;

    public HypComPerpConstraint(KernelCircle c, KernelArc d1, KernelArc d2, KernelArc o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._D1 = d1;
        this.theInput[1] = this._D1;
        this._D2 = d2;
        this.theInput[2] = this._D2;
        this.RH = o1;
        this.theOutput[0] = this.RH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7007), "br.ufrj.labma.enibam.kernel.KernelArcCR2A", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypComPerpConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RH.setDefinedStatus(false);
            return;
        }
        this.RH.setDefinedStatus(true);
        CoorSys I = new CoorSys(this._D1.getCenterX(), this._D1.getCenterY());
        CoorSys J = new CoorSys(this._D2.getCenterX(), this._D2.getCenterY());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        CoorSys A = new CoorSys();
        CoorSys B = new CoorSys();
        if (Intersection.InterLineCircle(I, new MathVector(I, J), O, R, B, A)) {
            Vector res = new Vector();
            if (NonEuclidMath.poincareLine3pts(A, B, O, R, res)) {
                this.RH.set3Points((CoorSys)res.elementAt(0), (CoorSys)res.elementAt(1), (CoorSys)res.elementAt(2));
            } else {
                this.RH.setDefinedStatus(false);
            }
        } else {
            this.RH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

