/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;

public class HypCompasConstraint
extends AbstractConstraint {
    private KernelPoint _O;
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelCircle _C;
    private KernelCircle CH;

    public HypCompasConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelPoint p2, KernelCircle o1) {
        super(4, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._O = p0;
        this.theInput[1] = this._O;
        this._A = p1;
        this.theInput[2] = this._A;
        this._B = p2;
        this.theInput[3] = this._B;
        this.CH = o1;
        this.theOutput[0] = this.CH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7006), "br.ufrj.labma.enibam.kernel.KernelCircle2P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypCompasConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.CH.setDefinedStatus(false);
            return;
        }
        this.CH.setDefinedStatus(true);
        CoorSys O = new CoorSys(this._O.getX(), this._O.getY());
        CoorSys A = new CoorSys(this._A.getX(), this._A.getY());
        CoorSys B = new CoorSys(this._B.getX(), this._B.getY());
        CoorSys OH = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double RH = this._C.getRadius();
        CoorSys cr = new CoorSys();
        if (NonEuclidMath.CrossRatio2HP(A, B, OH, RH, cr)) {
            CoorSys CP;
            O.itsX -= this._C.getCenterX();
            O.itsY -= this._C.getCenterY();
            if (Math.abs(O.itsX) + Math.abs(O.itsY) < 1.0E-5) {
                double b = RH * (cr.itsX - 1.0) / (1.0 + cr.itsX);
                CP = new CoorSys(b, 0.0);
            } else {
                double a = Math.sqrt(O.itsX * O.itsX + O.itsY * O.itsY);
                double b = RH * ((RH + a) * cr.itsX - RH + a) / (a * (RH - a + cr.itsX * (RH + a)));
                CP = new CoorSys(b * O.itsX, b * O.itsY);
            }
            O.itsX += this._C.getCenterX();
            O.itsY += this._C.getCenterY();
            CP.itsX += this._C.getCenterX();
            CP.itsY += this._C.getCenterY();
            CoorSys CC = new CoorSys();
            if (NonEuclidMath.poincareCircleEuclidianCenter(O, CP, OH, RH, CC)) {
                this.CH.setCenterPoint(CC, CP);
            } else {
                this.CH.setDefinedStatus(false);
            }
        } else {
            this.CH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

