/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.Vector;

public class HypLine2PConstraint
extends AbstractConstraint {
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelCircle _C;
    private KernelArc RH;

    public HypLine2PConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelArc o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._A = p0;
        this.theInput[1] = this._A;
        this._B = p1;
        this.theInput[2] = this._B;
        this.RH = o1;
        this.theOutput[0] = this.RH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7001), "br.ufrj.labma.enibam.kernel.KernelArcCR2A", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypLine2PConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RH.setDefinedStatus(false);
            return;
        }
        CoorSys A = new CoorSys(this._A.getX(), this._A.getY());
        CoorSys B = new CoorSys(this._B.getX(), this._B.getY());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        if (Math.abs((A.itsX - O.itsX) * (B.itsY - O.itsY) - (A.itsY - O.itsY) * (B.itsX - O.itsX)) < 1.0E-5) {
            CoorSys I = new CoorSys((A.itsX + B.itsX) / 2.0, (A.itsY + B.itsY) / 2.0);
            CoorSys I1 = new CoorSys();
            CoorSys I2 = new CoorSys();
            if (Intersection.InterLineCircle(A, new MathVector(A, B), O, R, I1, I2)) {
                this.RH.set3Points(A, I, B);
                this.RH.setDefinedStatus(true);
            } else {
                this.RH.setDefinedStatus(false);
            }
            return;
        }
        Vector res = new Vector();
        if (NonEuclidMath.poincareLine3pts(A, B, O, R, res)) {
            this.RH.set3Points((CoorSys)res.elementAt(0), (CoorSys)res.elementAt(1), (CoorSys)res.elementAt(2));
            this.RH.setDefinedStatus(true);
        } else {
            this.RH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

