/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class HypMediatrizConstraint
extends AbstractConstraint {
    private KernelArc theSeg;
    private KernelArc theArc;
    private KernelCircle _C;

    public HypMediatrizConstraint(KernelCircle c, KernelArc seg, KernelArc arc) {
        super(2, 1);
        this.theSeg = seg;
        this.theInput[0] = this.theSeg;
        this._C = c;
        this.theInput[1] = this._C;
        this.theArc = arc;
        this.theOutput[0] = this.theArc;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7008), "br.ufrj.labma.enibam.kernel.KernelArcCR2A", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypMediatrizConstraint", 1);
    }

    @Override
    public void calculate() {
        CoorSys __A = new CoorSys();
        CoorSys __B = new CoorSys();
        CoorSys _temp = new CoorSys();
        CoorSys __O = new CoorSys();
        CoorSys __I = new CoorSys();
        CoorSys __Aprime = new CoorSys();
        CoorSys __Bprime = new CoorSys();
        if (this.isSomeInputUndefined()) {
            this.theArc.setDefinedStatus(false);
            return;
        }
        this._C.getCenter(__O);
        double radius = this._C.getRadius();
        this.theSeg.get3Points(__A, _temp, __B);
        if (Math.sqrt((Distance.getDistance2(__A, __O) - Distance.getDistance2(__B, __O)) * (Distance.getDistance2(__A, __O) - Distance.getDistance2(__B, __O))) < 0.1) {
            if (Math.abs(Distance.getDistance(__A, __B)) < 1.0E-5) {
                MathVector V = new MathVector(__A, __B).orthogonal();
                CoorSys I = new CoorSys((__A.itsX + __B.itsX) / 2.0, (__A.itsY + __B.itsY) / 2.0);
                CoorSys ext1 = new CoorSys();
                CoorSys ext2 = new CoorSys();
                Intersection.InterLineCircle(I, V, __O, radius, ext1, ext2);
                this.theArc.set3Points(ext1, I, ext2);
                this.theArc.setDefinedStatus(true);
                return;
            }
        } else {
            if (Distance.getDistance2(__A, __O) < 0.1) {
                NonEuclidMath.inversePt(__B, __O, radius, __Bprime);
                __I.itsX = __B.itsX;
                __I.itsY = __B.itsY;
            } else if (Distance.getDistance2(__B, __O) < 0.1) {
                NonEuclidMath.inversePt(__A, __O, radius, __Aprime);
                __I.itsX = __A.itsX;
                __I.itsY = __A.itsY;
            } else {
                NonEuclidMath.inversePt(__A, __O, radius, __Aprime);
                NonEuclidMath.inversePt(__B, __O, radius, __Bprime);
                Intersection.InterLines(__A, __B, __Aprime, __Bprime, __I);
            }
            CoorSys _T1 = new CoorSys();
            CoorSys _T2 = new CoorSys();
            NonEuclidMath.tangentPoints(__I, __O, radius, _T1, _T2);
            if (Math.abs((_T1.itsX - __O.itsX) * (_T2.itsY - __O.itsY) - (_T1.itsY - __O.itsY) * (_T2.itsX - __O.itsX)) < 1.0E-5) {
                CoorSys I = new CoorSys((_T1.itsX + _T2.itsX) / 2.0, (_T1.itsY + _T2.itsY) / 2.0);
                this.theArc.set3Points(_T1, I, _T2);
                this.theArc.setDefinedStatus(true);
                return;
            }
            CoorSys LC = new CoorSys();
            if (NonEuclidMath.poincareLineEuclidianCenter(_T1, _T2, __O, radius, LC)) {
                CoorSys RI = new CoorSys((_T1.itsX + _T2.itsX) / 2.0 - LC.itsX, (_T1.itsY + _T2.itsY) / 2.0 - LC.itsY);
                double coef = Math.sqrt(((_T1.itsX - LC.itsX) * (_T1.itsX - LC.itsX) + (_T1.itsY - LC.itsY) * (_T1.itsY - LC.itsY)) / (RI.itsX * RI.itsX + RI.itsY * RI.itsY));
                RI.itsX = coef * RI.itsX + LC.itsX;
                RI.itsY = coef * RI.itsY + LC.itsY;
                this.theArc.set3Points(_T1, RI, _T2);
                this.theArc.setDefinedStatus(true);
            } else {
                this.theArc.setDefinedStatus(false);
            }
            return;
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

