/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelPointXY;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractOutputConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Distance;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;

public class HypMiddlePoint2PConstraint
extends AbstractConstraint {
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelPointXY _MP;
    private KernelCircle _C;

    public HypMiddlePoint2PConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelPointXY o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._A = p0;
        this.theInput[1] = this._A;
        this._B = p1;
        this.theInput[2] = this._B;
        this._MP = o1;
        this.theOutput[0] = this._MP;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractOutputConstruction(new Integer(7009), "br.ufrj.labma.enibam.kernel.KernelPointXY", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypMiddlePoint2PConstraint", 1);
    }

    @Override
    public void calculate() {
        CoorSys __A = new CoorSys();
        CoorSys __B = new CoorSys();
        CoorSys __O = new CoorSys();
        CoorSys __I = new CoorSys();
        CoorSys __Aprime = new CoorSys();
        CoorSys __Bprime = new CoorSys();
        if (this.isSomeInputUndefined()) {
            this._MP.setDefinedStatus(false);
            return;
        }
        this._C.getCenter(__O);
        double radius = this._C.getRadius();
        this._A.getXY(__A);
        this._B.getXY(__B);
        if (Math.sqrt((Distance.getDistance2(__A, __O) - Distance.getDistance2(__B, __O)) * (Distance.getDistance2(__A, __O) - Distance.getDistance2(__B, __O))) < 0.1) {
            this._MP.setDefinedStatus(true);
            if (Distance.getDistance(__A, __B) == 0.0) {
                this._MP.setXY(__A.itsX, __A.itsY);
            } else {
                this._MP.setXY((__A.itsX + __B.itsX) / 2.0, (__A.itsY + __B.itsY) / 2.0);
            }
            return;
        }
        if (Distance.getDistance2(__A, __O) < 0.1) {
            NonEuclidMath.inversePt(__B, __O, radius, __Bprime);
            __I.itsX = __B.itsX;
            __I.itsY = __B.itsY;
        } else if (Distance.getDistance2(__B, __O) < 0.1) {
            NonEuclidMath.inversePt(__A, __O, radius, __Aprime);
            __I.itsX = __A.itsX;
            __I.itsY = __A.itsY;
        } else {
            NonEuclidMath.inversePt(__A, __O, radius, __Aprime);
            NonEuclidMath.inversePt(__B, __O, radius, __Bprime);
            Intersection.InterLines(__A, __B, __Aprime, __Bprime, __I);
        }
        CoorSys _T1 = new CoorSys();
        CoorSys _T2 = new CoorSys();
        NonEuclidMath.tangentPoints(__I, __O, radius, _T1, _T2);
        this._MP.setDefinedStatus(true);
        CoorSys __OH = new CoorSys();
        NonEuclidMath.poincareLineEuclidianCenter(__A, __B, __O, radius, __OH);
        CoorSys _I1 = new CoorSys();
        CoorSys _I2 = new CoorSys();
        Intersection.InterCircles(__OH, Distance.getDistance(__OH, __A), __I, Distance.getDistance(__I, _T1), _I1, _I2);
        if (Distance.getDistance(__O, _I1) <= radius) {
            this._MP.setXY(_I1.itsX, _I1.itsY);
        } else if (Distance.getDistance(__O, _I2) <= radius) {
            this._MP.setXY(_I2.itsX, _I2.itsY);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

