/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;
import java.util.Vector;

public class HypPerpConstraint
extends AbstractConstraint {
    private KernelPoint _P;
    private KernelArc _D;
    private KernelCircle _C;
    private KernelArc RH;

    public HypPerpConstraint(KernelCircle c, KernelArc d, KernelPoint p, KernelArc o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._D = d;
        this.theInput[1] = this._D;
        this._P = p;
        this.theInput[2] = this._P;
        this.RH = o1;
        this.theOutput[0] = this.RH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7004), "br.ufrj.labma.enibam.kernel.KernelArcCR2A", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypPerpConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RH.setDefinedStatus(false);
            return;
        }
        CoorSys P = new CoorSys(this._P.getX(), this._P.getY());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        CoorSys DO = new CoorSys(this._D.getCenterX(), this._D.getCenterY());
        CoorSys PK = (CoorSys)P.clone();
        NonEuclidMath.fromPoincare2Klein(PK, O, R);
        CoorSys A = new CoorSys();
        CoorSys B = new CoorSys();
        if (Intersection.InterLineCircle(DO, new MathVector(PK, DO), O, R, A, B)) {
            Vector res = new Vector();
            if (NonEuclidMath.poincareLine3pts(A, B, O, R, res)) {
                this.RH.set3Points((CoorSys)res.elementAt(0), (CoorSys)res.elementAt(1), (CoorSys)res.elementAt(2));
                this.RH.setDefinedStatus(true);
            } else {
                this.RH.setDefinedStatus(false);
            }
        } else {
            this.RH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

