/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelArc;
import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;

public class HypRay2PConstraint
extends AbstractConstraint {
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelCircle _C;
    private KernelArc RH;

    public HypRay2PConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelArc o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._A = p0;
        this.theInput[1] = this._A;
        this._B = p1;
        this.theInput[2] = this._B;
        this.RH = o1;
        this.theOutput[0] = this.RH;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7002), "br.ufrj.labma.enibam.kernel.KernelArcCR2A", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.HypRay2PConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RH.setDefinedStatus(false);
            return;
        }
        this.RH.setDefinedStatus(true);
        CoorSys A = new CoorSys(this._A.getX(), this._A.getY());
        CoorSys B = new CoorSys(this._B.getX(), this._B.getY());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        CoorSys H1 = new CoorSys();
        CoorSys H2 = new CoorSys();
        if (NonEuclidMath.hypLineHorizonPoints(A, B, O, R, H1, H2)) {
            this.RH.set3Points(A, B, H1);
        } else {
            this.RH.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

