/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelConic;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.Vector;

public class KleinCircleCPConstraint
extends AbstractConstraint {
    private KernelPoint _O;
    private KernelPoint _M;
    private KernelCircle _C;
    private KernelConic CK;

    public KleinCircleCPConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelConic o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._O = p0;
        this.theInput[1] = this._O;
        this._M = p1;
        this.theInput[2] = this._M;
        this.CK = o1;
        this.theOutput[0] = this.CK;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7106), "br.ufrj.labma.enibam.kernel.KernelConic5P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.KleinCircleCPConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.CK.setDefinedStatus(false);
            return;
        }
        this.CK.setDefinedStatus(true);
        CoorSys O = new CoorSys(this._O.getX(), this._O.getY());
        CoorSys M = new CoorSys(this._M.getX(), this._M.getY());
        CoorSys OH = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double RH = this._C.getRadius();
        Vector l = new Vector();
        if (NonEuclidMath.kleinCircle5Points(O, M, OH, RH, l)) {
            this.CK.calculate(l);
        } else {
            this.CK.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

