/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class KleinComPerpConstraint
extends AbstractConstraint {
    private KernelSegment _D1;
    private KernelSegment _D2;
    private KernelCircle _C;
    private KernelSegment RK;

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7105), "br.ufrj.labma.enibam.kernel.KernelSegment2P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.KleinComPerpConstraint", 1);
    }

    public KleinComPerpConstraint(KernelCircle c, KernelSegment d1, KernelSegment d2, KernelSegment o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._D1 = d1;
        this.theInput[1] = this._D1;
        this._D2 = d2;
        this.theInput[2] = this._D2;
        this.RK = o1;
        this.theOutput[0] = this.RK;
        this.calculate();
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RK.setDefinedStatus(false);
            return;
        }
        this.RK.setDefinedStatus(true);
        CoorSys A = new CoorSys(this._D1.getX1(), this._D1.getY1());
        CoorSys B = new CoorSys(this._D1.getX2(), this._D1.getY2());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        CoorSys I = new CoorSys();
        if (Intersection.InterLines(A, new MathVector(O, A).orthogonal(), B, new MathVector(O, B).orthogonal(), I)) {
            A.itsX = this._D2.getX1();
            A.itsY = this._D2.getY1();
            B.itsX = this._D2.getX2();
            B.itsY = this._D2.getY2();
            CoorSys J = new CoorSys();
            if (Intersection.InterLines(A, new MathVector(O, A).orthogonal(), B, new MathVector(O, B).orthogonal(), J)) {
                CoorSys I1 = new CoorSys();
                CoorSys I2 = new CoorSys();
                if (Intersection.InterLineCircle(I, new MathVector(I, J), O, R, I1, I2)) {
                    this.RK.setP1P2(I1, I2);
                } else {
                    this.RK.setDefinedStatus(false);
                }
            } else {
                this.RK.setDefinedStatus(false);
            }
        } else {
            this.RK.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

