/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelConic;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.NonEuclidMath;
import br.ufrj.labma.enibam.kernel.state.State;
import java.util.Vector;

public class KleinCompasConstraint
extends AbstractConstraint {
    private KernelPoint _O;
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelCircle _C;
    private KernelConic CK;

    public KleinCompasConstraint(KernelCircle c, KernelPoint o, KernelPoint p1, KernelPoint p2, KernelConic o1) {
        super(4, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._O = o;
        this.theInput[1] = this._O;
        this._A = p1;
        this.theInput[2] = this._A;
        this._B = p2;
        this.theInput[3] = this._B;
        this.CK = o1;
        this.theOutput[0] = this.CK;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7107), "br.ufrj.labma.enibam.kernel.KernelConic5P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.KleinCompasConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.CK.setDefinedStatus(false);
            return;
        }
        this.CK.setDefinedStatus(true);
        CoorSys O = new CoorSys(this._O.getX(), this._O.getY());
        CoorSys A = new CoorSys(this._A.getX(), this._A.getY());
        CoorSys B = new CoorSys(this._B.getX(), this._B.getY());
        CoorSys OH = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double RH = this._C.getRadius();
        CoorSys cr = new CoorSys();
        if (NonEuclidMath.CrossRatio2KP(A, B, OH, RH, cr)) {
            CoorSys M;
            O.itsX -= this._C.getCenterX();
            O.itsY -= this._C.getCenterY();
            if (Math.abs(O.itsX) + Math.abs(O.itsY) < 1.0E-5) {
                double b = RH * (cr.itsX - 1.0) / (1.0 + cr.itsX);
                M = new CoorSys(b, 0.0);
            } else {
                double a = Math.sqrt(O.itsX * O.itsX + O.itsY * O.itsY);
                double b = RH * ((RH + a) * cr.itsX - RH + a) / (a * (RH - a + cr.itsX * (RH + a)));
                M = new CoorSys(b * O.itsX, b * O.itsY);
            }
            O.itsX += this._C.getCenterX();
            O.itsY += this._C.getCenterY();
            M.itsX += this._C.getCenterX();
            M.itsY += this._C.getCenterY();
            Vector l = new Vector();
            if (NonEuclidMath.kleinCircle5Points(O, M, OH, RH, l)) {
                this.CK.calculate(l);
            } else {
                this.CK.setDefinedStatus(false);
            }
        } else {
            this.CK.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

