/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.operations.Intersection;
import br.ufrj.labma.enibam.kernel.state.State;
import br.ufrj.labma.enibam.util.MathVector;

public class KleinPerpConstraint
extends AbstractConstraint {
    private KernelPoint _P;
    private KernelSegment _D;
    private KernelCircle _C;
    private KernelSegment RK;

    public KleinPerpConstraint(KernelCircle c, KernelSegment d, KernelPoint p, KernelSegment o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._D = d;
        this.theInput[1] = this._D;
        this._P = p;
        this.theInput[2] = this._P;
        this.RK = o1;
        this.theOutput[0] = this.RK;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7104), "br.ufrj.labma.enibam.kernel.KernelSegment2P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.KleinPerpConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RK.setDefinedStatus(false);
            return;
        }
        this.RK.setDefinedStatus(true);
        CoorSys P = new CoorSys(this._P.getX(), this._P.getY());
        CoorSys A = new CoorSys(this._D.getX1(), this._D.getY1());
        CoorSys B = new CoorSys(this._D.getX2(), this._D.getY2());
        CoorSys O = new CoorSys(this._C.getCenterX(), this._C.getCenterY());
        double R = this._C.getRadius();
        CoorSys I = new CoorSys();
        if (Intersection.InterLines(A, new MathVector(O, A), B, new MathVector(O, B), I)) {
            CoorSys I1 = new CoorSys();
            CoorSys I2 = new CoorSys();
            if (Intersection.InterLineCircle(I, new MathVector(I, P), O, R, I1, I2)) {
                this.RK.setP1P2(I1, I2);
            } else {
                this.RK.setDefinedStatus(false);
            }
        } else {
            this.RK.setDefinedStatus(false);
        }
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

