/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.constraint.noneuclid;

import br.ufrj.labma.enibam.kernel.KernelCircle;
import br.ufrj.labma.enibam.kernel.KernelPoint;
import br.ufrj.labma.enibam.kernel.KernelSegment;
import br.ufrj.labma.enibam.kernel.constraint.AbstractConstraint;
import br.ufrj.labma.enibam.kernel.construction.AbstractInverseTranslatePropagationConstruction;
import br.ufrj.labma.enibam.kernel.construction.Construction;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.kernel.state.State;

public class KleinSegment2PConstraint
extends AbstractConstraint {
    private KernelPoint _A;
    private KernelPoint _B;
    private KernelCircle _C;
    private KernelSegment RK;

    public KleinSegment2PConstraint(KernelCircle c, KernelPoint p0, KernelPoint p1, KernelSegment o1) {
        super(3, 1);
        this._C = c;
        this.theInput[0] = this._C;
        this._A = p0;
        this.theInput[1] = this._A;
        this._B = p1;
        this.theInput[2] = this._B;
        this.RK = o1;
        this.theOutput[0] = this.RK;
        this.calculate();
    }

    public static Construction getConstruction() {
        return new AbstractInverseTranslatePropagationConstruction(new Integer(7103), "br.ufrj.labma.enibam.kernel.KernelSegment2P", "br.ufrj.labma.enibam.kernel.constraint.noneuclid.KleinSegment2PConstraint", 1);
    }

    @Override
    public void calculate() {
        if (this.isSomeInputUndefined()) {
            this.RK.setDefinedStatus(false);
            return;
        }
        this.RK.setDefinedStatus(true);
        CoorSys A = new CoorSys(this._A.getX(), this._A.getY());
        CoorSys B = new CoorSys(this._B.getX(), this._B.getY());
        this.RK.setP1P2(A, B);
    }

    @Override
    public boolean isOk(State P) {
        return false;
    }
}

