/*
 * Decompiled with CFR 0.152.
 */
package br.ufrj.labma.enibam.kernel.dummy;

import br.ufrj.labma.enibam.kernel.dummy.KernelDummyGenericLine;
import br.ufrj.labma.enibam.kernel.operations.CoorSys;
import br.ufrj.labma.enibam.util.MathVector;

public abstract class AbstractKernelDummyGenericLine
implements KernelDummyGenericLine {
    protected double itsX1;
    protected double itsX2;
    protected double itsY1;
    protected double itsY2;

    public AbstractKernelDummyGenericLine() {
    }

    public AbstractKernelDummyGenericLine(CoorSys c1, CoorSys c2) {
        this.itsX1 = c1.itsX;
        this.itsY1 = c1.itsY;
        this.itsX2 = c2.itsX;
        this.itsY2 = c2.itsY;
    }

    @Override
    public abstract boolean contains(CoorSys var1);

    @Override
    public void getP1P2(CoorSys p1, CoorSys p2) {
        p1.itsX = this.itsX1;
        p1.itsY = this.itsY1;
        p2.itsX = this.itsX2;
        p2.itsY = this.itsY2;
    }

    @Override
    public double getX1() {
        return this.itsX1;
    }

    @Override
    public double getY1() {
        return this.itsY1;
    }

    @Override
    public double getX2() {
        return this.itsX2;
    }

    @Override
    public double getY2() {
        return this.itsY2;
    }

    @Override
    public void setP1P2(CoorSys p1, CoorSys p2) {
        this.itsX1 = p1.itsX;
        this.itsY1 = p1.itsY;
        this.itsX2 = p2.itsX;
        this.itsY2 = p2.itsY;
    }

    @Override
    public void setP1P2(double x1, double y1, double x2, double y2) {
        this.itsX1 = x1;
        this.itsY1 = y1;
        this.itsX2 = x2;
        this.itsY2 = y2;
    }

    @Override
    public void getVector(MathVector v) {
        v.setX(this.itsX2 - this.itsX1);
        v.setY(this.itsY2 - this.itsY1);
    }

    @Override
    public boolean isVertical() {
        return this.itsX1 == this.itsX2;
    }

    @Override
    public double getAngularCoef() throws ArithmeticException {
        double quoc = this.itsX2 - this.itsX1;
        if (quoc == 0.0) {
            throw new ArithmeticException("Trying to take the Angular Coef. of a vertical line!");
        }
        return (this.itsY2 - this.itsY1) / quoc;
    }

    @Override
    public double getA() {
        return this.itsY2 - this.itsY1;
    }

    @Override
    public double getB() {
        return this.itsX1 - this.itsX2;
    }

    @Override
    public double getC() {
        return this.itsX2 * this.itsY1 - this.itsX1 * this.itsY2;
    }

    public void translate(double dx, double dy) {
        this.itsX1 += dx;
        this.itsX2 += dx;
        this.itsY1 += dy;
        this.itsY2 += dy;
    }

    public String toString() {
        CoorSys _p1 = new CoorSys();
        CoorSys _p2 = new CoorSys();
        this.getP1P2(_p1, _p2);
        return this.getClass().getName();
    }
}

